% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_contingency_tabs.R
\name{expr_contingency_tab}
\alias{expr_contingency_tab}
\title{Making expression for contingency table and goodness of fit tests}
\usage{
expr_contingency_tab(
  data,
  x,
  y = NULL,
  counts = NULL,
  paired = FALSE,
  ratio = NULL,
  k = 2L,
  conf.level = 0.95,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The variable to use as the \strong{rows} in the contingency table.}

\item{y}{The variable to use as the \strong{columns} in the contingency table.
Default is \code{NULL}. If \code{NULL}, one-sample proportion test (a goodness of fit
test) will be run for the \code{x} variable. Otherwise association test will be
carried out.}

\item{counts}{A string naming a variable in data containing counts, or \code{NULL}
if each row represents a single observation.}

\item{paired}{Logical indicating whether data came from a within-subjects or
repeated measures design study (Default: \code{FALSE}). If \code{TRUE}, McNemar's
test subtitle will be returned. If \code{FALSE}, Pearson's chi-square test will
be returned.}

\item{ratio}{A vector of proportions: the expected proportions for the
proportion test (should sum to 1). Default is \code{NULL}, which means the null
is equal theoretical proportions across the levels of the nominal variable.
This means if there are two levels this will be \code{ratio = c(0.5,0.5)} or if
there are four levels this will be \code{ratio = c(0.25,0.25,0.25,0.25)}, etc.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Expression for contingency analysis (Pearson's chi-square test for
independence for between-subjects design or McNemar's test for
within-subjects design) or goodness of fit test for a single categorical
variable.
}
\description{
Making expression for contingency table and goodness of fit tests
}
\details{
For more details about how the effect sizes and their confidence
intervals were computed, see documentation in \code{?effectsize::cramers_v} and
\code{?effectsize::cohens_g}.
}
\examples{
# for reproducibility
set.seed(123)
library(statsExpressions)

# ------------------------ association tests -----------------------------

# without counts data
expr_contingency_tab(
  data = mtcars,
  x = am,
  y = cyl,
  paired = FALSE
)

# ------------------------ goodness of fit tests ---------------------------

# with counts
expr_contingency_tab(
  data = as.data.frame(HairEyeColor),
  x = Eye,
  counts = Freq,
  ratio = c(0.2, 0.2, 0.3, 0.3)
)
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
