context("expr_anova_parametric - between-subjects")

# parametric anova subtitles (without NAs) -----------------------------------

testthat::test_that(
  desc = "parametric anova subtitles work (without NAs)",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = statsExpressions::movies_long,
        x = genre,
        y = rating,
        effsize.type = "partial_eta",
        k = 5,
        var.equal = FALSE,
        nboot = 10,
        messages = FALSE
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "8",
          ",",
          "399.03535",
          ") = ",
          "28.41410",
          ", ",
          italic("p"),
          " = ",
          "< 0.001",
          ", ",
          widehat(eta["p"]^2),
          " = ",
          "0.13123",
          ", CI"["95%"],
          " [",
          "0.09826",
          ", ",
          "0.15804",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          1579L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# parametric anova subtitles (with NAs) --------------------------------------

testthat::test_that(
  desc = "parametric anova subtitles work (with NAs)",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # output from statsExpression helper subtitle
    set.seed(123)
    using_function1 <-
      suppressWarnings(
        statsExpressions::expr_anova_parametric(
          data = ggplot2::msleep,
          x = vore,
          y = sleep_total,
          k = 3,
          effsize.type = "biased",
          partial = FALSE,
          conf.level = 0.95,
          messages = FALSE
        )
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "3",
          ",",
          "16.586",
          ") = ",
          "1.405",
          ", ",
          italic("p"),
          " = ",
          "0.277",
          ", ",
          widehat(eta^2),
          " = ",
          "0.085",
          ", CI"["95%"],
          " [",
          "-0.008",
          ", ",
          "0.258",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          76L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# parametric anova subtitles (partial omega) ----------------------------------

testthat::test_that(
  desc = "parametric anova subtitles with partial omega-squared",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = ggplot2::msleep,
        x = vore,
        y = "sleep_rem",
        effsize.type = "partial_omega",
        k = 4,
        nboot = 10,
        messages = FALSE
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "3",
          ",",
          "11.1010",
          ") = ",
          "2.6325",
          ", ",
          italic("p"),
          " = ",
          "0.1017",
          ", ",
          widehat(omega["p"]^2),
          " = ",
          "0.1438",
          ", CI"["95%"],
          " [",
          "-0.0241",
          ", ",
          "0.4012",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          56L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# parametric anova subtitles (partial eta and NAs) --------------------------

testthat::test_that(
  desc = "parametric anova subtitles with partial eta-squared and data with NAs",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = ggplot2::msleep,
        x = vore,
        y = sleep_rem,
        var.equal = TRUE,
        effsize.type = "partial_eta",
        k = 4,
        nboot = 10,
        messages = FALSE
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "3",
          ",",
          "52",
          ") = ",
          "4.1361",
          ", ",
          italic("p"),
          " = ",
          "0.0105",
          ", ",
          widehat(eta["p"]^2),
          " = ",
          "0.1926",
          ", CI"["95%"],
          " [",
          "0.0129",
          ", ",
          "0.3387",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          56L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# checking non-partial variants ----------------------------------

testthat::test_that(
  desc = "parametric anova subtitles with partial eta-squared and data with NAs",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    # eta
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = ggplot2::msleep,
        x = vore,
        y = sleep_rem,
        effsize.type = "biased",
        conf.level = 0.95,
        partial = FALSE,
        k = 4,
        nboot = 10,
        messages = FALSE
      )

    # omega
    set.seed(123)
    using_function2 <-
      statsExpressions::expr_anova_parametric(
        data = ggplot2::msleep,
        x = vore,
        y = sleep_rem,
        effsize.type = "unbiased",
        partial = FALSE,
        k = 4,
        conf.level = 0.99,
        nboot = 10,
        messages = FALSE
      )

    # expected output
    # eta
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "3",
          ",",
          "11.1010",
          ") = ",
          "2.6325",
          ", ",
          italic("p"),
          " = ",
          "0.1017",
          ", ",
          widehat(eta^2),
          " = ",
          "0.1926",
          ", CI"["95%"],
          " [",
          "0.0319",
          ", ",
          "0.4387",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          56L
        )
      )

    # omega
    results2 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "3",
          ",",
          "11.1010",
          ") = ",
          "2.6325",
          ", ",
          italic("p"),
          " = ",
          "0.1017",
          ", ",
          widehat(omega^2),
          " = ",
          "0.1438",
          ", CI"["99%"],
          " [",
          "NA",
          ", ",
          "0.3932",
          "]",
          ", ",
          italic("n")["obs"],
          " = ",
          56L
        )
      )

    # testing overall call
    # eta
    testthat::expect_identical(using_function1, results1)

    # omega
    testthat::expect_identical(using_function2, results2)
  }
)

# parametric repeated anova subtitles (basic) ---------------------------------

testthat::test_that(
  desc = "parametric anova subtitles work (without NAs)",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = statsExpressions::iris_long,
        x = "condition",
        y = value,
        paired = TRUE,
        nboot = 20,
        k = 3,
        conf.level = 0.99,
        messages = TRUE
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "1.149",
          ",",
          "171.217",
          ") = ",
          "776.318",
          ", ",
          italic("p"),
          " = ",
          "< 0.001",
          ", ",
          widehat(omega^2),
          " = ",
          "0.707",
          ", CI"["99%"],
          " [",
          "0.758",
          ", ",
          "0.825",
          "]",
          ", ",
          italic("n")["pairs"],
          " = ",
          150L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# parametric repeated anova subtitles ---------------------------------

testthat::test_that(
  desc = "parametric anova subtitles work (with NAs)",
  code = {
    testthat::skip_if(getRversion() < "3.6")

    # statsExpression output
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = WRS2::WineTasting,
        x = Wine,
        y = Taste,
        paired = TRUE,
        effsize.type = "biased",
        sphericity.correction = FALSE,
        k = 4,
        conf.level = 0.99,
        messages = FALSE
      )

    # expected output
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "2",
          ",",
          "42",
          ") = ",
          "6.2883",
          ", ",
          italic("p"),
          " = ",
          "0.0041",
          ", ",
          widehat(eta["p"]^2),
          " = ",
          "0.2304",
          ", CI"["99%"],
          " [",
          "0.0020",
          ", ",
          "0.4598",
          "]",
          ", ",
          italic("n")["pairs"],
          " = ",
          22L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)

    # statsExpression output
    set.seed(123)
    using_function2 <-
      statsExpressions::expr_anova_parametric(
        data = WRS2::WineTasting,
        x = Wine,
        y = Taste,
        paired = TRUE,
        effsize.type = "bogus",
        k = 5,
        conf.level = 0.90,
        nboot = 15,
        messages = FALSE
      )

    # expected output
    results2 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "1.54700",
          ",",
          "32.48706",
          ") = ",
          "6.28831",
          ", ",
          italic("p"),
          " = ",
          "0.00844",
          ", ",
          widehat(omega^2),
          " = ",
          "0.01701",
          ", CI"["90%"],
          " [",
          "0.03464",
          ", ",
          "0.28869",
          "]",
          ", ",
          italic("n")["pairs"],
          " = ",
          22L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function2, results2)
  }
)

# parametric repeated anova subtitles (catch bad data) -----------------------

testthat::test_that(
  desc = "parametric anova subtitles work (catch bad data)",
  code = {
    testthat::skip_if(getRversion() < "3.6")
    # statsExpression output

    # fake a data entry mistake
    iris_long[5, 3] <- "Sepal.Width"

    # sample size should be different
    set.seed(123)
    using_function1 <-
      statsExpressions::expr_anova_parametric(
        data = iris_long,
        x = condition,
        y = value,
        paired = TRUE,
        effsize.type = "eta",
        partial = FALSE,
        conf.level = 0.50,
        messages = FALSE
      )

    # expected
    results1 <-
      ggplot2::expr(
        paste(
          NULL,
          italic("F"),
          "(",
          "1.28",
          ",",
          "189.93",
          ") = ",
          "686.64",
          ", ",
          italic("p"),
          " = ",
          "< 0.001",
          ", ",
          widehat(eta["p"]^2),
          " = ",
          "0.82",
          ", CI"["50%"],
          " [",
          "0.81",
          ", ",
          "0.83",
          "]",
          ", ",
          italic("n")["pairs"],
          " = ",
          149L
        )
      )

    # testing overall call
    testthat::expect_identical(using_function1, results1)
  }
)

# checking warning message when too few obs --------------------------------

testthat::test_that(
  desc = "checking warning message when too few obs",
  code = {
    testthat::skip_on_cran()
    testthat::skip_if(getRversion() < "3.6")
    set.seed(123)

    # dataframe
    df <- structure(list(
      x = c(
        30, 40, 50, 60, 70, 80, 90, 30, 40, 50,
        60, 70, 80, 90, 30, 40, 50, 60, 70, 80, 90, 30, 40, 50, 60, 70,
        80, 90, 30, 40, 50, 60, 70, 80, 90
      ),
      Participant = c(
        "FH2", "FH2",
        "FH2", "FH2", "FH2", "FH2", "FH2", "ZW", "ZW", "ZW", "ZW", "ZW",
        "ZW", "ZW", "KS", "KS", "KS", "KS", "KS", "KS", "KS", "CL", "CL",
        "CL", "CL", "CL", "CL", "CL", "AG", "AG", "AG", "AG", "AG", "AG",
        "AG"
      ),
      Method = c(
        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
        2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2
      ),
      y = c(
        2571.25, 2688.003333, 2779.363333, 2832.046667,
        3050.72, 3255.553333, 3327.173667, 1766.296667, 2107.890333,
        2391.7, 2569.24, 2680.22, 2807.59, 2807.953333, 2078.734,
        2414.366667, 2583.27, 2923.253333, 3085.96, 3094.003333,
        3121.49, 2824.990667, 2716.429667, 2844.323333, 3124.713333,
        3252.863333, 3424.24, 3674.463333, 2401.996667, 2719.046667,
        2712.99, 2951.965667, 3046.526667, 3100.902667, 3195.331333
      )
    ),
    class = c("spec_tbl_df", "tbl_df", "tbl", "data.frame"),
    row.names = c(NA, -35L),
    spec = structure(list(
      cols = list(
        x = structure(list(), class = c("collector_double", "collector")),
        Participant = structure(list(), class = c(
          "collector_character",
          "collector"
        )),
        Method = structure(list(), class = c(
          "collector_double",
          "collector"
        )),
        y = structure(list(), class = c(
          "collector_double",
          "collector"
        ))
      ),
      default = structure(list(), class = c(
        "collector_guess",
        "collector"
      )), skip = 1
    ),
    class = "col_spec"
    )
    )

    # capture the message
    set.seed(123)
    p_sub <-
      suppressWarnings(statsExpressions::expr_anova_parametric(
        data = df,
        x = x,
        y = y,
        paired = TRUE,
        messages = FALSE
      ))

    # check that
    testthat::expect_identical(
      p_sub,
      ggplot2::expr(paste(
        NULL,
        italic("F"),
        "(",
        "6",
        ",",
        "24",
        ") = ",
        "43.14",
        ", ",
        italic("p"),
        " = ",
        "< 0.001",
        ", ",
        widehat(omega^2),
        " = ",
        "0.60",
        ", CI"["95%"],
        " [",
        "0.77",
        ", ",
        "0.93",
        "]",
        ", ",
        italic("n")["pairs"],
        " = ",
        5L
      ))
    )
  }
)
