% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.mean2}
\alias{size.ci.mean2}
\title{Sample size for a 2-group mean difference confidence interval}
\usage{
size.ci.mean2(alpha, var, w, R)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{var}{planning value of average within-group variance}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size for each group required to estimate a population
mean difference with desired confidence interval precision in a 2-group
design. Set R = 1 for equal sample sizes. Set the variance planning value
to the largest value within a plausible range for a conservatively large
sample size.
}
\examples{
size.ci.mean2(.05, 37.1, 5, 1)

# Should return:
# n1  n2
# 47  47
 

}
