% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{power.cor2}
\alias{power.cor2}
\title{Approximates the power of a test for equal correlations in a 2-group design
for planned sample sizes}
\usage{
power.cor2(alpha, n1, n2, cor1, cor2, s)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{n1}{planned sample size for group 1}

\item{n2}{planned sample size for group 2}

\item{cor1}{planning value of correlation for group 1}

\item{cor2}{planning value of correlation for group 1}

\item{s}{number of control variables}
}
\value{
Returns the approximate power of the test
}
\description{
Computes the approximate power of a test for equal population Pearson or
partial correlations in a 2-group design for planned sample sizes. Set
s = 0 for a Pearson correlation.
}
\examples{
power.cor2(.05, 200, 200, .4, .2, 0)

# Should return:
#          Power
# [1,] 0.5919517


}
