% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.2x2.prop.mixed}
\alias{ci.2x2.prop.mixed}
\title{Computes tests and confidence intervals of effects in a 2x2 mixed factorial
design for proportions}
\usage{
ci.2x2.prop.mixed(alpha, group1, group2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{group1}{2x2 contingency table for Factor A in group 1}

\item{group2}{2x2 contingency table for Factor A in group 2}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - adjusted estimate of effect
\item SE - standard error of estimate
\item z - z test statistic
\item p - p-value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals and tests for the AB
interaction effect, main effect of A, main efect of B, simple main effects
of A, and simple main effects of B in a 2x2 mixed factorial design with a
dichotomous response variable where Factor A is a within-subjects factor
and Factor B is a between-subjects factor. The 4x1 vector of frequency
counts for Factor A within each group is f00, f01, f10, f11 where fij is
the number of participants with a response of i = 0 or 1 at level 1 of
Factor A and a response of j = 0 or 1 at level 2 of Factor A.
}
\examples{
group1 = c(23, 42, 24, 11)
group2 = c(26, 27, 13, 34)
ci.2x2.prop.mixed (.05, group1, group2)

# Should return:
#            Estimate         SE         z           p           LL        UL
# AB:      0.03960396 0.09991818 0.3963639 0.691836584 -0.156232072 0.2354400
# A:       0.15841584 0.04995909 3.1709113 0.001519615  0.060497825 0.2563339
# B:       0.09803922 0.04926649 1.9899778 0.046593381  0.001478675 0.1945998
# A at b1: 0.17647059 0.07893437 2.2356621 0.025373912  0.021762060 0.3311791
# A at b2: 0.13725490 0.06206620 2.2114274 0.027006257  0.015607377 0.2589024
# B at a1: 0.11764706 0.06842118 1.7194539 0.085531754 -0.016455982 0.2517501
# B at a2: 0.07843137 0.06913363 1.1344894 0.256589309 -0.057068054 0.2139308


}
