% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.R
\name{st_downsample}
\alias{st_downsample}
\alias{st_downsample.stars}
\alias{st_downsample.stars_proxy}
\title{downsample stars or stars_proxy objects}
\usage{
st_downsample(x, n, ...)

\method{st_downsample}{stars}(x, n, ..., offset = 0, FUN)

\method{st_downsample}{stars_proxy}(x, n, ...)
}
\arguments{
\item{x}{object of class stars or stars_proxy}

\item{n}{integer; for each dimension the number of pixels/lines/bands etc that will be skipped; see Details.}

\item{...}{arguments passed on to \code{FUN} (e.g., \code{na.rm = TRUE} to ignore missing values if FUN is \code{mean})}

\item{offset}{integer; offset(s) for downsampling, in pixels, starting at the offset of 
each dimension; should be smaller or equal to \code{n}}

\item{FUN}{function; if given, downsampling will apply FUN to each of the the subtiles}
}
\description{
downsample a stars or stars_proxy object either by skipping rows, columns and bands,
or by computing a single value (e.g. the mean) from the sub-tiles involved
}
\details{
If all n == 0, no downsampling takes place; if it is 1, every second row/column/band
is skipped, if it is 2, every second+third row/column/band are skipped, etc.

Downsampling a \code{stars_proxy} object returns a \code{stars} object, is
equivalent to calling \code{st_as_stars(x, downsample = 2)}, and only downsamples
the first two (x and y) dimensions.

Downsampled regular rasters keep their dimension offsets, have a cell size (delta) that
is n[i]+1 times larger, and may result in a (slightly) different extent.

Note that terra's \link[terra]{aggregate} with \code{fact=2} corresponds to
\code{st_downsample(x, n = 1, FUN = mean)}: \code{fact} is one larger than \code{n}.
}
\examples{
(m = matrix(1:121, 11, 11))
(s = st_as_stars(m))
st_downsample(s, 1)
st_downsample(s, 1)[[1]]
st_downsample(s, 1, offset = 1)
st_downsample(s, 1, offset = 1)[[1]]
st_downsample(s, 1, offset = c(0,1))
st_downsample(s, 1, offset = c(0,1))[[1]]
st_downsample(s, 1, FUN = mean)
st_downsample(s, 1, FUN = mean)[[1]]
st_downsample(s, 1, offset = 1, FUN = mean)
st_downsample(s, 1, offset = c(0,1), FUN = mean)[[1]]
}
