% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns-dependencies.R, R/ns-handler.R
\name{useNS}
\alias{useNS}
\alias{notice}
\title{Notification Styles}
\usage{
useNS()

notice(
  message = "Hello",
  type = "notice",
  layout = "growl",
  effect = "jelly",
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{message}{Notification message.}

\item{type}{Notification type. Defaults to \code{"notice"}. Other valid values are:
\itemize{
\item \code{"success"}
\item \code{"warning"}
\item \code{"error"}
}}

\item{layout}{Notification layout. Defaults to \code{"growl"}. Other valid values are:
\itemize{
\item \code{"attached"}
\item \code{"bar"}
}}

\item{effect}{Notification effect type. Valid values include:
\itemize{
\item For \code{"growl"} layout
\itemize{
\item \code{"scale"}
\item \code{"jelly"}
\item \code{"slide"}
\item \code{"genie"}
}
\item For\code{"attached"} layout
\itemize{
\item \code{"flip"}
\item \code{"bouncyflip"}
}
\item For \code{"bar"} layout
\itemize{
\item \code{"slidetop"}
\item \code{"exploader"}
}
}}

\item{session}{Shiny session object.}
}
\value{
None
}
\description{
Simple website notifications with effects
}
\section{Functions}{

\itemize{
\item \code{useNS}: Dependencies to include in your UI.
\item \code{notice}: Display notifications.
}
}

\examples{
if (interactive()) {
library(shiny)
library(standby)

ui <- fluidPage(

  useNS(), # include dependencies
  actionButton(inputId = "btn",
               label   = "Notice Demo")

)

server <- function(input, output, session) {

  observeEvent(input$btn, {
    # display notification
    notice("Hey there! Thank you for exploring standby!")
  })
}

shinyApp(ui, server)
}

}
