% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microtip-dependencies.R, R/microtip-handler.R
\name{useMicroTip}
\alias{useMicroTip}
\alias{microTip}
\title{MicroTip}
\usage{
useMicroTip()

microTip(
  id = NULL,
  tip = "Hey! tooltip!",
  position = "top",
  size = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{The id of the element to attach the tooltip.}

\item{tip}{Content of the tooltip.}

\item{position}{Where the tooltip should appear relative to the target element. Defaults to \code{"top"}. Valid values are:
\itemize{
\item \code{"top"}
\item \code{"bottom"}
\item \code{"left"}
\item \code{"right"}
\item \code{"top-left"}
\item \code{"top-right"}
\item \code{"bottom-left"}
\item \code{"bottom-right"}
}}

\item{size}{Size of the tooltip. Defaults to \code{"fit"} as the tooltip will takeup only the size it requires to show the text.
Valid values are:
\itemize{
\item \code{"fit"}
\item \code{"small"}
\item \code{"medium"}
\item \code{"large"}
}}

\item{session}{Shiny session object.}
}
\value{
None
}
\description{
Minimal CSS only tooltip.
}
\section{Functions}{

\itemize{
\item \code{useMicroTip}: Dependencies to include in your UI.
\item \code{microTip}: Add tooltip.
}
}

\examples{
if (interactive()) {
library(shiny)
library(standby)

ui <- fluidPage(

  useMicroTip(), # include dependencies
  br(), br(), br(), br(),
  actionButton(inputId = "btn",
               label   = "MicroTip Demo")

)

server <- function(input, output, session) {

  # display tooltip
  microTip(id = "btn",
           tip = "Hey there! This is a micro tip!",
           position = "bottom-right")

}

shinyApp(ui, server)
}

}
