% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_anova.R
\name{add_anova}
\alias{add_anova}
\title{Additive ANOVA for Genotypes by Environment Interaction (GEI) model}
\usage{
add_anova(data, Rep, G, E, Y)
}
\arguments{
\item{data}{data.frame}

\item{Rep}{Replication Factor}

\item{G}{Genotypes Factor}

\item{E}{Environment Factor}

\item{Y}{Response Variable}
}
\value{
Additive ANOVA
}
\description{
Additive ANOVA for Genotypes by Environment Interaction (GEI) model
}
\examples{
data(ge_data)
YieldANOVA <-
     add_anova(
        data = ge_data
      , Rep  = Rep
      , G    = Gen
      , E    = Env
      , Y    = Yield
      )[[1]]
YieldANOVA

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
