% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypoTests.R
\name{LR_test}
\alias{LR_test}
\title{Perform likelihood ratio test for a STVAR model}
\usage{
LR_test(stvar1, stvar2)
}
\arguments{
\item{stvar1}{an object of class \code{'stvar'} generated by \code{fitSTVAR} or \code{STVAR}, containing
the \strong{freely estimated} model.}

\item{stvar2}{an object of class \code{'stvar'} generated by \code{fitSTVAR} or \code{STVAR}, containing
the \strong{constrained} model.}
}
\value{
A list with class "hypotest" containing the test results and arguments used to calculate the test.
}
\description{
\code{LR_test} performs a likelihood ratio test for a STVAR model
}
\details{
Performs a likelihood ratio test, testing the null hypothesis that the true parameter value lies
  in the constrained parameter space. Under the null, the test statistic is asymptotically
  \eqn{\chi^2}-distributed with \eqn{k} degrees of freedom, \eqn{k} being the difference in the dimensions
  of the unconstrained and constrained parameter spaces.

  \strong{The test is based on the assumption of the standard result of asymptotic normality!}
  Also, note that this function does \strong{not} verify that the two models are actually nested.
}
\examples{
# Logistic Student's t STVAR with p=1, M=2, and the first lag of the second variable
# as the switching variable (parameter values were obtained by maximum likelihood estimation;
 # fitSTVAR is not used here because the estimation is computationally demanding).
params12 <- c(0.62906848, 0.14245295, 2.41245785, 0.66719269, 0.3534745, 0.06041779, -0.34909745,
  0.61783824, 0.125769, -0.04094521, -0.99122586, 0.63805416, 0.371575, 0.00314754, 0.03440824,
  1.29072533, -0.06067807, 0.18737385, 1.21813844, 5.00884263, 7.70111672)
fit12 <- STVAR(data=gdpdef, p=1, M=2, params=params12, weight_function="logistic",
  weightfun_pars=c(2, 1), cond_dist="Student")
fit12

## Test whether the location parameter equals 1:

# Same as the original model but with the location parameter constrained to 1
# (parameter values were obtained by maximum likelihood estimation; fitSTVAR
# is not used here because the estimation is computationally demanding).
params12w <- c(0.6592583, 0.16162866, 1.7811393, 0.38876396, 0.35499367, 0.0576433,
 -0.43570508, 0.57337706, 0.16449607, -0.01910167, -0.70747014, 0.75386158, 0.3612087,
  0.00241419, 0.03202824, 1.07459924, -0.03432236, 0.14982445, 6.22717097, 8.18575651)
fit12w <- STVAR(data=gdpdef, p=1, M=2, params=params12w, weight_function="logistic",
 weightfun_pars=c(2, 1), cond_dist="Student",
 weight_constraints=list(R=matrix(c(0, 1), nrow=2), r=c(1, 0)))

# Test the null hypothesis of the location parameter equal 1:
LR_test(fit12, fit12w)

## Test whether the means and AR matrices are identical across the regimes:

# Same as the original model but with the mean and AR matrices constrained identical
# across the regimes (parameter values were obtained by maximum likelihood estimation;
# fitSTVAR is not used here because the estimation is computationally demanding).
params12cm <- c(0.76892423, 0.67128089, 0.30824474, 0.03530802, -0.11498402, 0.85942541,
 0.39106754, 0.0049437, 0.03897287, 1.44457723, -0.05939876, 0.20885008, 1.23568782,
 6.42128475, 7.28733557)
fit12cm <- STVAR(data=gdpdef, p=1, M=2, params=params12cm, weight_function="logistic",
 weightfun_pars=c(2, 1), parametrization="mean", cond_dist="Student",
 mean_constraints=list(1:2), AR_constraints=rbind(diag(4), diag(4)))

# Test the null hypothesis of the means and AR matrices being identical across the regimes:
LR_test(fit12, fit12cm)
}
\references{
\itemize{
   \item Buse A. (1982). The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note.
     \emph{The American Statistician}, 36(3a), 153-157.
 }
}
\seealso{
\code{\link{Wald_test}}, \code{\link{Rao_test}}, \code{\link{fitSTVAR}}, \code{\link{STVAR}},
  \code{\link{diagnostic_plot}}, \code{\link{profile_logliks}}, \code{\link{Portmanteau_test}}
}
