% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moreEst.R
\name{iterate_more}
\alias{iterate_more}
\title{Maximum likelihood estimation of a reduced form or structural STVAR model based on preliminary estimates}
\usage{
iterate_more(
  stvar,
  maxit = 100,
  h = 0.001,
  penalized,
  penalty_params,
  allow_unstab,
  calc_std_errors = TRUE,
  print_trace = TRUE
)
}
\arguments{
\item{stvar}{an object of class \code{'stvar'}, created by, e.g., \code{fitSTVAR} or \code{fitSSTVAR}.}

\item{maxit}{the maximum number of iterations in the variable metric algorithm.}

\item{h}{the step size used in the central difference approximation of the gradient of the log-likelihood function, so
\code{h} should be a small positive real number.}

\item{penalized}{should penalized log-likelihood function be used that penalizes the log-likelihood function when
the parameter values are close the boundary of the stability region or outside it? If \code{TRUE}, estimates
that do not satisfy the stability condition are allowed (except when \code{weight_function="relative_dens"}).
The default is \code{TRUE} for three-phase estimation and \code{FALSE} for two-phase estimation.}

\item{penalty_params}{a numeric vector with two positive elements specifying the penalization parameters:
the first element determined how far from the boundary of the stability region the penalization starts
(a number between zero and one, smaller number starts penalization closer to the boundary) and the second element
is a tuning parameter for the penalization (a positive real number, a higher value penalizes non-stability more).}

\item{allow_unstab}{If \code{TRUE}, estimates not satisfying the stability condition are allowed. Always \code{FALSE} if
\code{weight_function="relative_dens"}.}

\item{calc_std_errors}{Calculate approximate standard errors (based on standard asymptotics)?}

\item{print_trace}{should the trace of the optimization algorithm be printed?}
}
\value{
Returns an S3 object of class \code{'stvar'} defining a smooth transition VAR model. The returned list
 contains the following components (some of which may be \code{NULL} depending on the use case):
   \item{data}{The input time series data.}
   \item{model}{A list describing the model structure.}
   \item{params}{The parameters of the model.}
   \item{std_errors}{Approximate standard errors of the parameters, if calculated.}
   \item{transition_weights}{The transition weights of the model.}
   \item{regime_cmeans}{Conditional means of the regimes, if data is provided.}
   \item{total_cmeans}{Total conditional means of the model, if data is provided.}
   \item{total_ccovs}{Total conditional covariances of the model, if data is provided.}
   \item{uncond_moments}{A list of unconditional moments including regime autocovariances, variances, and means.}
   \item{residuals_raw}{Raw residuals, if data is provided.}
   \item{residuals_std}{Standardized residuals, if data is provided.}
   \item{structural_shocks}{Recovered structural shocks, if applicable.}
   \item{loglik}{Log-likelihood of the model, if data is provided.}
   \item{IC}{The values of the information criteria (AIC, HQIC, BIC) for the model, if data is provided.}
   \item{all_estimates}{The parameter estimates from all estimation rounds, if applicable.}
   \item{all_logliks}{The log-likelihood of the estimates from all estimation rounds, if applicable.}
   \item{which_converged}{Indicators of which estimation rounds converged, if applicable.}
   \item{which_round}{Indicators of which round of optimization each estimate belongs to, if applicable.}
   \item{LS_estimates}{The least squares estimates of the parameters in the form
     \eqn{(\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\alpha} (intercepts replaced by unconditional means
     if mean parametrization is used), if applicable.}
}
\description{
\code{iterate_more} uses a variable metric algorithm to estimate a reduced form or structural STVAR model
 (object of class \code{'stvar'}) based on preliminary estimates.
}
\details{
The purpose of \code{iterate_more} is to provide a simple and convenient tool to finalize
  the estimation when the maximum number of iterations is reached when estimating a STVAR model
  with the main estimation function \code{fitSTVAR} or \code{fitSSTVAR}.
}
\examples{
\donttest{
## These are long running examples that take approximately 20 seconds to run.

# Estimate two-regime Gaussian STVAR p=1 model with the weighted relative stationary densities
# of the regimes as the transition weight function, but only 5 iterations of the variable matrix
# algorithm:
fit12 <- fitSTVAR(gdpdef, p=1, M=2, nrounds=1, seeds=1, ncores=1, maxit=5)

# The iteration limit was reached, so the estimate is not local maximum.
# The gradient of the log-likelihood function:
get_foc(fit12) # Not close to zero!

# So, we run more iterations of the variable metric algorithm:
fit12 <- iterate_more(fit12)

# The gradient of the log-likelihood function after iterating more:
get_foc(fit12) # Close (enough) to zero!
}
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hubrich K., Teräsvirta. T. 2013. Thresholds and Smooth Transitions in Vector Autoregressive Models.
     \emph{CREATES Research Paper 2013-18, Aarhus University.}
   \item Koivisto T., Luoto J., Virolainen S. 2025. Unpublished working paper.
   \item Lanne M., Virolainen S. 2024. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{Econometric Reviews}, \strong{39}:4, 407-414.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2024. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{fitSTVAR}}, \code{\link{STVAR}}, \code{\link[stats]{optim}},
 \code{\link{swap_B_signs}}, \code{\link{reorder_B_columns}}
}
