% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excelToSstModel.R
\name{keywordToTransposedTable}
\alias{keywordToTransposedTable}
\title{Extract a table from the excel template}
\usage{
keywordToTransposedTable(path, keyword, mapping.tables, colNames = NULL)
}
\arguments{
\item{path}{a character value. A valid path of an input excel workbook.
The path can be relative or not.}

\item{keyword}{a character value. A valid keyword corresponding to a table.}

\item{mapping.tables}{a data.frame with following fields:
\itemize{
  \item \code{keyword}: character, list of keywords.
  \item \code{name}: character, sheet names corresponding to the keywords.
  \item \code{startRow}: integer, starting row number corresponding to position in
    the excel sheet.
  \item \code{startCol}: integer, starting column number corresponding to position in
    the excel sheet.
}}

\item{colNames}{character vector, the colnames to be given to the parsed table.}
}
\value{
the corresponding table.
}
\description{
this function extracts transposed tables from the excel input
workbook.
}
\seealso{
\code{\link{excelToSstModel}}.
}
