% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-general.R
\name{changeBaseCurrency}
\alias{changeBaseCurrency}
\title{Change Covariance Matrix According to Change of Base Currency}
\usage{
changeBaseCurrency(cov.mat, mapping.table, target.currency, mapping.name)
}
\arguments{
\item{cov.mat}{matrix value corresponding to the covariance matrix of base risk factors. This
matrix should have an attribute named "base.currency" indicating the actual base currency in
which the covariance matrix is expressed.}

\item{mapping.table}{S3 object of class mappingTable that should be coherent with the \code{cov.mat}.}

\item{target.currency}{character value of length one indicating the new base currency, this should exists
in the \code{mapping.table}.}

\item{mapping.name}{data.frame indicating the mapping towards new name in the covariance
matrix and in the mapping.table for the new fx rate with two columns:
\itemize{
  \item \code{old.name}: the names of the old risk factors in the covariance matrix.
  \item \code{new.name}: the new names of these risk factors.
}}
}
\value{
a list with two named fields:
  \itemize{
    \item \code{cov.mat}: the new covariance matrix.
    \item \code{mapping.table} the new mapping.table.
  }
}
\description{
This function allow to change the base risk factor covariance matrix according
  to a change of base currency, the function also update the mapping.table and ask the user
  to provide new names for the new fx base risks.
}
