% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cashflow-base.R
\name{cashflow}
\alias{cashflow}
\title{Constructing a Fixed-Income-Asset}
\usage{
cashflow(time, currency, rating, spread, value)
}
\arguments{
\item{time}{stricly positive integer value of length one representing the
time-to-maturity. This parameter relates to the \emph{"Restlaufzeit"} cashflow variable
\code{tau} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{currency}{character value of length one representing the currency in
which the fixed-income-asset is labeled. This parameter relates
 to the \emph{"Fremdwährungsrisikofaktor"} cashflow index \code{j} in the FINMA
 document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{rating}{character value of length one representing the rating associated
to the fixed-income-asset. This parameter relates to the \emph{"Rating"} cashflow variable
\code{r} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{spread}{a numeric value of length one representing the initial spread corresponding
to the fixed-income-asset. This parameter relates to the cashflow variable
\eqn{S(0,j,r)} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
A warning is triggered if \code{spread} is below -0.1 or above 0.3.}

\item{value}{non-zero numeric value of length one representing the expected cashflow
at time \code{time} for a fixed-income-asset with rating
\code{rating}. This must be expressed in the same currency as
\code{currency}. If \code{value} is negative, then the cashflow is interpreted
as a liability. This parameter corresponds to the cashflow quantity \deqn{CF^{A,r,j}_{\tau}}
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}
}
\value{
an S3 object, instance of the class cashflow.
}
\description{
Constructor for the S3 class cashflow.
  It allows to build for a fixed-income-asset referred under the
  name \emph{"Fixed-Income-Assets"} in the FINMA technical document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# Creating new cashflows.
cashflow1 <- cashflow(1L, "USD", "AAA", 0.1, 1000)
cashflow2 <- cashflow(2L, "EUR", "BB", 0.1, 2000)

}
\seealso{
\code{\link{summary.cashflow}}, \code{\link{print.cashflow}}.
}
