% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assetForward-base.R
\name{assetForward}
\alias{assetForward}
\title{Constructing an Index-Forward}
\usage{
assetForward(type, currency, time, exposure, price, position)
}
\arguments{
\item{type}{character value of length one representing the type of the underlying asset position.
This parameter relates to the index \code{i} in the valuation formula of index-forwards
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
This parameter is the same as the \emph{"Preisrisikofaktor"} index \code{i} for asset valuation
in the same document. \code{type} cannot be one of the following reserved character:
\itemize{
  \item \code{"currency"}
  \item \code{"rate"}
  \item \code{"pcRate"}
  \item \code{"spread"}
}}

\item{currency}{character value of length one representing the currency in which
the underlying asset is valuated. This parameter relates
to the \emph{"Fremdwährungsrisikofaktor"} index \code{j} in the FINMA document
\emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{time}{stricly positive integer value of length one representing the
time-to-maturity from \eqn{t = 0}. This parameter relates to the variable
\code{tau} in valuation formula for assetForwards in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{exposure}{strictly non-zero numeric value of length one. The exposure in the
underlying asset covered by the forward contract, this must be expressed in the same
currency as \code{currency}. This parameter corresponds to the quantity \deqn{\hat{E}_{0,i,j}}
for assetForwards in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
If \code{exposure} is set to \code{0}, a warning will be triggered.}

\item{price}{numeric value of length one representing the forward price. This parameter
relates to the assetForward variable \deqn{\hat{F}^{j}_{\tau}} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
This must be expressed in the same currency as \code{currency}.}

\item{position}{character value of length one. This can be either
\code{"long"} or \code{"short"} according to the definition of
\emph{long} and \emph{short} forwards in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}
}
\value{
an S3 object, instance of the class fxForward.
}
\description{
Constructor for the S3 class assetForward.
  It allows to build for an index-forward referred under the
  name \emph{"Index-Forward"} in the FINMA technical document
  \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\note{
The underlying equity shall be defined using \code{asset}.
}
\examples{
# Creating new assetForwards.
asset.froward.1 <- assetForward("equity", "EUR", 1, 1000, 1200, "long")
asset.forward.2 <- assetForward("private real estate","CHF", 7, 100, 90,
                                "short")

}
\seealso{
\code{\link{summary.assetForward}}, \code{\link{print.assetForward}}.
}
