% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asset-base.R
\name{asset}
\alias{asset}
\title{Constructing an Asset with Direct Market Price}
\usage{
asset(type, currency, value)
}
\arguments{
\item{type}{character value of length one representing the type of the asset position. This parameter relates
to the \emph{"Preisrisikofaktor"}  index \code{i} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
\code{type} cannot be one of the following
reserved character:
\itemize{
  \item \code{"currency"}
  \item \code{"rate"}
  \item \code{"pcRate"}
  \item \code{"spread"}
}}

\item{currency}{character value of length one representing the currency in which
the asset is valuated. This parameter relates
 to the \emph{"Fremdwährungsrisikofaktor"} index \code{j} in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}

\item{value}{non-zero numeric value of length one representing the exposure in the
underlying asset. This must be expressed in the same currency as
\code{currency}. Note that if \code{value} is negative the position
is interpreted as a \emph{short position}. If the value is set to 0,
a warning will be triggered. This parameter corresponds to the quantity \deqn{\hat{E}_{0,i,j}} for asset with direct market price
in the FINMA document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.}
}
\value{
an S3 object, instance of the class \code{asset}.
}
\description{
Constructor for the S3 class asset.
  It allows to build for an asset position with direct market price
  known under the name \emph{"Aktiven mit direkt marktabhängigen Preisen"}
  in the FINMA technical document \emph{"SST-Marktrisiko und -Aggregation Technische Beschreibung"}.
}
\examples{
# Creating new assets.
asset1 <- asset("equity", "CHF", 1000)
asset2 <- asset("hedge fund", "EUR", 2000)


}
\seealso{
\code{\link{summary.asset}}, \code{\link{print.asset}}.
}
