% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trajectory.R
\name{plot_trajectory}
\alias{plot_trajectory}
\alias{plot_trajectory,sspm_fit,sspm_dataset,character,character-method}
\title{Plot trajectory of exploitation rate with biomass}
\usage{
plot_trajectory(sspm_object, dataset, biomass, catch, ...)

\S4method{plot_trajectory}{sspm_fit,sspm_dataset,character,character}(sspm_object, dataset, biomass, catch, dataset_biomass = NULL)
}
\arguments{
\item{sspm_object}{\strong{[sspm_dataset or sspm_fit]} The dataset object.}

\item{dataset}{\strong{[sspm_dataset]} Corresponding biomass dataset.}

\item{biomass}{\strong{[character]} Biomass variable for plotting.}

\item{catch}{\strong{[character]} Catch variable for plotting}

\item{...}{More arguments passed onto \code{fun}}

\item{dataset_biomass}{\strong{[character]} Biomass variable for plotting in
the biomass dataset if the variable name is different there.}
}
\value{
A ggplot2 plot object.
}
\description{
Provides a trajectory plot for exploitation rate (ER), defined as the ratio
between catch of a given year and fishable biomass from the previous year,
and that fishable biomass.
}
\examples{
\dontrun{
plot_trajectory(sspm_fit, borealis_dataset_fitted,
                "weight_per_km2", "catch")
}

}
