% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fitdists}
\alias{predict.fitdists}
\title{Predict Hazard Concentrations of fitdists Object}
\usage{
\method{predict}{fitdists}(
  object,
  percent = 1:99,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  average = TRUE,
  delta = 7,
  min_pboot = 0.99,
  parametric = TRUE,
  control = NULL,
  ...
)
}
\arguments{
\item{object}{The object.}

\item{percent}{A numeric vector of percentages.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by parametric bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits. A value of 10000 is recommended for official guidelines.}

\item{average}{A flag specifying whether to model average the estimates.}

\item{delta}{A non-negative number specifying the maximum absolute Akaike Information-theoretic Criterion difference cutoff. Distributions with an absolute difference from the best model greater than the cutoff are excluded.}

\item{min_pboot}{A number of the minimum proportion of bootstrap samples that must successfully fit
in the sense of returning a likelihood.}

\item{parametric}{A flag specifying whether to perform parametric as opposed to non-parametric bootstrapping.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}

\item{...}{Unused.}
}
\description{
A wrapper on \code{\link[=ssd_hc]{ssd_hc()}} that by default calculates
all hazard concentrations from 1 to 99\%.
}
\details{
It is useful for plotting purposes.
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
predict(fits)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}} and \code{\link[=ssd_plot]{ssd_plot()}}
}
