% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{ssd_fit_dist}
\alias{ssd_fit_dist}
\title{Fit Distribution}
\usage{
ssd_fit_dist(data, left = "Conc", right = left, weight = NULL,
  dist = "lnorm")
}
\arguments{
\item{data}{A data frame.}

\item{left}{A string of the column in data with the left concentration values.}

\item{right}{A string of the column in data with the right concentration values.}

\item{weight}{A string of the column in data with the weightings (or NULL)}

\item{dist}{A string of the distribution to fit.}
}
\value{
An object of class \code{\link[fitdistrplus]{fitdist}}.
}
\description{
Fits a distribution to species sensitivity data.
}
\examples{
ssd_fit_dist(boron_data)
data(fluazinam)
ssd_fit_dist(fluazinam, left = "left", right = "right")
}
\seealso{
\code{\link{ssd_fit_dists}}
}
