% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaseClassifierOneNN.R
\name{predict.OneNN}
\alias{predict.OneNN}
\title{Model Predictions}
\usage{
\method{predict}{OneNN}(object, dists, type = "class", ...)
}
\arguments{
\item{object}{A model of class OneNN built with \code{\link{oneNN}}}

\item{dists}{A matrix of distances between the instances to classify (by rows) and
the instances used to train the model (by column)}

\item{type}{It is a string that can take two values: \code{"class"} for computing the class of
the instances or \code{"prob"} for computing the probabilities of belonging to each class.}

\item{...}{Currently not used.}
}
\value{
If \code{type} is equal to \code{"class"} a vector of length equal to the rows number
of matrix \code{dists}, containing the predicted labels. If \code{type} is equal
to \code{"prob"} it returns a matrix which has \code{nrow(dists)} rows and a column for every
class, where each cell represents the probability that the instance belongs to the class,
according to 1NN.
}
\description{
This function predicts the class label of instances or its probability of
pertaining to each class based on the distance matrix.
}

