% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS_methods.R
\name{biplot.msPCA}
\alias{biplot.msPCA}
\title{Biplot Visualization for msPCA Objects}
\usage{
\method{biplot}{msPCA}(x, ...)
}
\arguments{
\item{x}{An object of class \code{msPCA}.}

\item{...}{Additional graphical parameters to customize the plot:
\describe{
  \item{\code{shape}}{Integer or character; shape of the points (default: 43).}
  \item{\code{size}}{Numeric; size of the points/text (default: 3).}
  \item{\code{alpha}}{Numeric between 0 and 1; transparency of the points/text (default: 0.7).}
  \item{\code{color}}{Character; determines the coloring scheme of points, either \code{"variable"} or \code{"groups"} (default: \code{"variable"}).}
}}
}
\value{
A \code{ggplot2} object representing the biplot of the first two principal components.
}
\description{
Creates a biplot of the first two principal components from an \code{msPCA} object,
displaying variables or groups in the component space.
}
\examples{
set.seed(236)
data <- matrix(rnorm(2000), ncol = 4)
groups <- sample(1:10, 500, replace = TRUE)
W <- time_weights(N = 10, c(3,2,1))
covs <- ssMRCD(data, groups = groups, weights = W, lambda = 0.3)
pca <- msPCA(eta = 0.3, gamma = 0.5,COVS = covs$MRCDcov, k = 2)
pca$PC = align(PC = pca$PC, type = "largest")
biplot(pca, alpha = 1, shape = 16, size = 5, color = "variable")

}
