% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics.r
\name{survey_quantile}
\alias{survey_median}
\alias{survey_quantile}
\title{Calculate the quantile and its variation using survey methods}
\usage{
survey_quantile(x, quantiles, na.rm = FALSE, vartype = c("none", "se",
  "ci"), level = 0.95, q_method = "linear", f = 1,
  interval_type = c("Wald", "score", "betaWald"), ties = c("discrete",
  "rounded"), df = Inf, ...)

survey_median(x, na.rm = FALSE, vartype = c("none", "se", "ci"),
  level = 0.95, q_method = "linear", f = 1, interval_type = c("Wald",
  "score", "betaWald"), ties = c("discrete", "rounded"), df = Inf, ...)
}
\arguments{
\item{x}{A variable or expression}

\item{quantiles}{A vector of quantiles to calculate}

\item{na.rm}{A logical value to indicate whether missing values should be dropped}

\item{vartype}{Report variability as one or more of: standard error ("se", default),
confidence interval ("ci") (variance and coefficient of variation not
available).}

\item{level}{A single number indicating the confidence level (only one level allowed)}

\item{q_method}{See "method" in \code{\link[stats]{approxfun}}}

\item{f}{See \code{\link[stats]{approxfun}}}

\item{interval_type}{See \code{\link[survey]{svyquantile}}}

\item{ties}{See \code{\link[survey]{svyquantile}}}

\item{df}{A number indicating the degrees of freedom for t-distribution. The
default, Inf uses the normal distribution (matches the survey package).
Also, has no effect for \code{type = "betaWald"}.}

\item{...}{Ignored}
}
\description{
Calculate quantiles from complex survey data. A wrapper
around \code{\link[survey]{svyquantile}}. \code{survey_quantile} and
\code{survey_median} should always be called from \code{\link{summarise}}.
}
\examples{
library(survey)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata \%>\%
  summarise(api99 = survey_quantile(api99, c(0.25, 0.5, 0.75)),
            api00 = survey_median(api00, vartype = c("ci")))

dstrata \%>\%
  group_by(awards) \%>\%
  summarise(api00 = survey_median(api00))

}

