% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total.est.R
\name{total.est}
\alias{total.est}
\title{Estimators for Population Total, Mean, Variance, and Standard Deviation}
\usage{
total.est(z, wgt, x = NULL, y = NULL, stratum = NULL,
  cluster = NULL, wgt1 = NULL, x1 = NULL, y1 = NULL,
  popsize = NULL, popcorrect = FALSE, pcfsize = NULL,
  N.cluster = NULL, stage1size = NULL, support = NULL,
  sizeweight = FALSE, swgt = NULL, swgt1 = NULL, vartype = "Local",
  conf = 95, check.ind = TRUE, warn.ind = NULL, warn.df = NULL,
  warn.vec = NULL)
}
\arguments{
\item{z}{Vector of the response value for each site.}

\item{wgt}{Vector of the final adjusted weight (inverse of the sample
inclusion probability) for each site, which is either the weight for a
single-stage sample or the stage two weight for a two-stage sample.}

\item{x}{Vector of x-coordinate for location for each site, which is either
the x-coordinate for a single-stage sample or the stage two x-coordinate
for a two-stage sample.  The default is NULL.}

\item{y}{Vector of y-coordinate for location for each site, which is either
the y-coordinate for a single-stage sample or the stage two y-coordinate
for a two-stage sample.  The default is NULL.}

\item{stratum}{Vector of the stratum for each site.  The default is NULL.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.  The default is NULL.}

\item{wgt1}{Vector of the final adjusted stage one weight for each site.
The default is NULL.}

\item{x1}{Vector of the stage one x-coordinate for location for each site.
The default is NULL.}

\item{y1}{Vector of the stage one y-coordinate for location for each site.
The default is NULL.}

\item{popsize}{Known size of the resource, which is used to calculate
strata proportions for calculating estimates for a stratified sample.  For
a finite resource, this argument is either the total number of sampling
units or the known sum of size-weights.  For an extensive resource, this
argument is the measure of the resource, i.e., either known total length
for a linear resource or known total area for an areal resource.  For a
stratified sample this variable must be a vector containing a value for
each stratum and must have the names attribute set to identify the stratum
codes.  The default is NULL.}

\item{popcorrect}{Logical value that indicates whether finite or continuous
population correction factors should be employed during variance
estimation, where TRUE = use the correction factor and FALSE = do not use
the correction factor.  The default is FALSE.  To employ the correction
factor for a single-stage sample, values must be supplied for arguments
pcfsize and support.  To employ the correction factor for a two-stage
sample, values must be supplied for arguments N.cluster, stage1size, and
support.}

\item{pcfsize}{Size of the resource, which is required for calculation of
finite and continuous population correction factors for a single-stage
sample. For a stratified sample this argument must be a vector containing a
value for each stratum and must have the names attribute set to identify
the stratum codes.  The default is NULL.}

\item{N.cluster}{The number of stage one sampling units in the resource,
which is required for calculation of finite and continuous population
correction factors for a two-stage sample.  For a stratified sample this
argument must be a vector containing a value for each stratum and must have
the names attribute set to identify the stratum codes.  The default is
NULL.}

\item{stage1size}{Size of the stage one sampling units of a two-stage
sample, which is required for calculation of finite and continuous
population correction factors for a two-stage sample and must have the
names attribute set to identify the stage one sampling unit codes.  For a
stratified sample, the names attribute must be set to identify both stratum
codes and stage one sampling unit codes using a convention where the two
codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1". The
default is NULL.}

\item{support}{Vector of the support value for each site - the value one
(1) for a site from a finite resource or the measure of the sampling unit
associated with a site from an extensive resource, which is required for
calculation of finite and continuous population correction factors.  The
default is NULL.}

\item{sizeweight}{Logical value that indicates whether size-weights should
be used in the analysis, where TRUE = use the size-weights and FALSE = do
not use the size-weights.  The default is FALSE.}

\item{swgt}{Vector of the size-weight for each site, which is the stage two
size-weight for a two-stage sample.  The default is NULL.}

\item{swgt1}{Vector of the stage one size-weight for each site.  The
default is NULL.}

\item{vartype}{The choice of variance estimator, where "Local" = local mean
estimator and "SRS" = SRS estimator.  The default is "Local".}

\item{conf}{Numeric value for the confidence level.  The default is 95.}

\item{check.ind}{Logical value that indicates whether compatability
checking of the input values is conducted, where TRUE = conduct
compatibility checking and FALSE = do not conduct compatibility checking.
The default is TRUE.}

\item{warn.ind}{Logical value that indicates whether warning messages were
generated, where TRUE = warning messages were generated and FALSE = warning
messages were not generated.  The default is NULL.}

\item{warn.df}{Data frame for storing warning messages.  The default is
NULL.}

\item{warn.vec}{Vector that contains names of the population type, the
subpopulation, and an indicator.  The default is NULL.}
}
\value{
If the function was called by the cont.analysis function, then
  output is an object in list format composed of the Results data frame,
  which contains estimates and confidence bounds, and the warn.df data frame,
  which contains warning messages.  If the function was called directly, then
  output is the Results data frame.
}
\description{
This function calculates estimates of the population total, mean, variance,
and standard deviation of a response variable, where the response variable
may be defined for either a finite or an extensive resource.  In addition the
standard error of the population estimates and confidence bounds are
calculated.  The Horvitz-Thompson estimator is used to calculate the total,
variance, and standard deviation estimates.  The Horvitz-Thompson ratio
estimator, i.e., the ratio of two Horvitz-Thompson estimators, is used to
calculate the mean estimate.  Variance estimates are calculated using either
the local mean variance estimator or the simple random sampling (SRS)
variance estimator.  The choice of variance estimator is subject to user
control.  The local mean variance estimator requires the x-coordinate and the
y-coordinate of each site.  The SRS variance estimator uses the independent
random sample approximation to calculate joint inclusion probabilities.
Confidence bounds are calculated using a Normal distribution multiplier. The
function can accommodate a stratified sample.  For a stratified sample,
separate estimates and standard errors are calculated for each stratum, which
are used to produce estimates and standard errors for all strata combined.
Strata that contain a single value are removed.  For a stratified sample,
when either the size of the resource or the sum of the size-weights of the
resource is provided for each stratum, those values are used as stratum
weights for calculating the estimates and standard errors for all strata
combined.  For a stratified sample when neither the size of the resource nor
the sum of the size-weights of the resource is provided for each stratum,
estimated values are used as stratum weights for calculating the estimates
and standard errors for all strata combined.  The function can accommodate
single-stage and two-stage samples for both stratified and unstratified
sampling designs.  Finite population and continuous population correction
factors can be utilized in variance estimation.  The function checks for
compatibility of input values and removes missing values.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{input.check}}}{check input values for errors,
      consistency, and compatibility with analytical functions}
    \item{\code{\link{wnas}}}{remove missing values}
    \item{\code{\link{vecprint}}}{takes an input vector and outputs a
      character string with line breaks inserted}
    \item{\code{\link{total.var}}}{calculate variance of the total, mean,
      variance, and standard deviation estimates}
  }
}

\examples{
z <- rnorm(100, 10, 1)
wgt <- runif(100, 10, 100)
total.est(z, wgt, vartype="SRS")

x <- runif(100)
y <- runif(100)
total.est(z, wgt, x, y)

}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
