% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{validate_parameters}
\alias{validate_parameters}
\title{Asssertion for Correct API Requests.}
\usage{
validate_parameters(
  artists_or_tracks = NULL,
  artist_or_user = NULL,
  market = NULL,
  country = NULL,
  limit = NULL,
  offset = NULL,
  locale = NULL,
  volume_percent = NULL,
  time_range = NULL,
  position_ms = NULL,
  state = NULL,
  include_meta_info = NULL
)
}
\arguments{
\item{artists_or_tracks}{The type parameter must be either 'artists' or 'tracks'."}

\item{artist_or_user}{"The type parameter must be either 'artist' or 'user'."}

\item{market}{Optional. \cr
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string \code{"from_token"}. Provide this parameter if you want to apply \href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{Track Relinking}}

\item{country}{Optional. \cr
An \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code} or the string \code{"from_token"}. Provide this parameter if you want to apply \href{https://developer.spotify.com/documentation/general/guides/track-relinking-guide/}{Track Relinking}}

\item{limit}{Optional. The maximum number of items to return.
Default to \code{20}. Minimum: 1. Maximum: 50.}

\item{offset}{Optional. The index of the first item to return.
Defaults to \code{0}, i.e., the first object.
Use with \code{limit} to get the next set of items.}

\item{locale}{Optional. The desired language, consisting of an
\href{https://en.wikipedia.org/wiki/ISO_639-1}{ISO 639-1} language code and
an \href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 3166-1 alpha-2 country code}, joined by an underscore. For example: \code{es_MX}, meaning "Spanish (Mexico)". Provide this parameter if you want the category strings returned in a particular language. Note that, if \code{locale} is not supplied, or if the specified language is not available, the category strings returned will be in the Spotify default language (American English). The \code{locale} parameter,
combined with the \code{country} parameter, may give odd results if not carefully matched.
For example \code{country=SE&locale=de_DE} will return a list of categories relevant to Sweden
but as German language strings.}

\item{volume_percent}{Required integer value. The volume to set.
Must be a value from 0 to 100 inclusive. Defaults to \code{50}.}

\item{time_range}{Optional. Over what time frame the affinities are computed.
Valid values: long_term (calculated from several years of data and including all new data
as it becomes available), \code{medium_term} (approximately last 6 months),
\code{short_term} (approximately last 4 weeks). Default: \code{medium_term}.}

\item{position_ms}{Optional. Integer indicating from what position to start playback. Must be a positive number. Passing in a position that is greater than the length of the track will cause the player to start playing the next song.}

\item{state}{The state parameter must be exactly one of \code{'track'},
\code{'context'} or  \code{'off'}.}

\item{include_meta_info}{Optional. Boolean indicating whether to include full result,
with meta information such as \code{"total"}, and \code{"limit"}. Defaults to \code{FALSE}.}
}
\value{
A boolean if the parameter matches the Spotify Web API parameter range.
}
\description{
Assertions are made to give early and precise error messages for wrong
API call parameters.
}
\details{
These assertions are called from various wrapper functions.  However, you can also call this
function directly to make sure that you are adding (programatically) the correct
parameters to a call.

All \code{\link{validate_parameters}} parameters default to \code{NULL}.
Asserts the correct parameter values for any values that are not \code{NULL}.
}
