% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/inspect.R
\name{inspect}
\alias{inspect}
\alias{inspect.data.frame}
\alias{inspect.occdat}
\alias{inspect.occkey}
\title{Get more data on individual occurrences.}
\usage{
inspect(x, from = "gbif")

\method{inspect}{data.frame}(x, from = "gbif")

\method{inspect}{occdat}(x, from = "gbif")

\method{inspect}{occkey}(x, from = "gbif")
}
\arguments{
\item{x}{The output from \code{\link{occ}} call, output from call to
\code{\link{occ2df}}, or an occurrence ID as a occkey class.}

\item{from}{(character) The data provider. One of gbif, bison, inat, antweb, ecoengine,
or vertnet}
}
\value{
A list, with each slot named for the data source, and then within data
sources is a slot for each taxon, named by it's occurrence ID.
}
\description{
Get more data on individual occurrences.
}
\examples{
\dontrun{
spnames <- c('Accipiter striatus', 'Carduelis tristis')
out <- occ(query=spnames, from=c('gbif','bison','ecoengine'),
   gbifopts=list(hasCoordinate=TRUE), limit=2)
res <- occ2df(out)
inspect(res)

out <- occ(query=spnames, from='gbif', gbifopts=list(hasCoordinate=TRUE), limit=4)
res <- occ2df(out)
inspect(res)

# from occkeys
key <- as.gbif(res$key[1])
inspect(key)
key <- as.antweb("amsat-94817")
inspect(key)

# idigbio
spnames <- c('Accipiter striatus', 'Carduelis tristis')
out <- occ(query=spnames, from='idigbio', limit=20)
inspect(out)
}
}

