% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tools.global.r
\name{color2blackwhite}
\alias{color2blackwhite}
\title{Convert colors to contrasted gray level for black and white rendering}
\usage{
color2blackwhite(x, increase.contrast = TRUE, contrast.min = 0.02,
  contrast.max = 0.98)
}
\arguments{
\item{x}{a \code{character}, the vector of color codes given in hexadecimal format (ex "#21AD5C").}

\item{increase.contrast}{a \code{logical}, if \code{TRUE} the scaling is performed.}

\item{contrast.min}{the minimal gray value to use in the scaling (0 = white, 1 = black).}

\item{contrast.max}{the maximal gray value to use in the scaling (0 = white, 1 = black).}
}
\description{
This function converts color codes (given in hexadecimal format) to constrasted gray levels. This is useful to enhance readability when printing in black and white. The conversion from color to gray levels is performed using the luminosity method (0.21R + 0.72G + 0.07B), then levels are linearly scaled to [contrast.min;contrast.max].
}
\examples{
mycols = c("#BA364E", "#32BAA1", "#12AA91")
color2blackwhite(mycols)

barplot(1:3, axes=FALSE, col=mycols)
barplot(1:3, axes=FALSE, col=color2blackwhite(mycols, increase.contrast = FALSE))
barplot(1:3, axes=FALSE, col=color2blackwhite(mycols))
barplot(1:3, axes=FALSE, col=color2blackwhite(mycols, contrast.min = 0, contrast.max = 1))
}

