% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatvalues.R
\name{hatvalues.spmodel}
\alias{hatvalues.spmodel}
\alias{hatvalues.splm}
\alias{hatvalues.spautor}
\title{Compute leverage (hat) values}
\usage{
\method{hatvalues}{splm}(model, ...)

\method{hatvalues}{spautor}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A vector of leverage (hat) values for each observation from the
fitted model object.
}
\description{
Compute the leverage (hat) value for each observation from a fitted
model object.
}
\details{
Leverage values measure how far an observation's explanatory variables
are relative to the average of the explanatory variables. In other words, observations with high
leverage are typically considered to have an extreme or unusual combination of explanatory
variables. Leverage values are the diagonal of the hat (projection) matrix.
The larger the hat value, the larger the leverage.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
hatvalues(spmod)
}
\seealso{
\code{\link[=cooks.distance.spmodel]{cooks.distance.spmodel()}} \code{\link[=influence.spmodel]{influence.spmodel()}} \code{\link[=residuals.spmodel]{residuals.spmodel()}}
}
