% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krigepred.R
\name{krigepred}
\alias{krigepred}
\title{Generate spatial predictions using kriging methods ('krige')}
\usage{
krigepred(
  trainx,
  trainy,
  trainx2,
  nmax = 12,
  transformation = "none",
  delta = 1,
  formula = var1 ~ 1,
  vgm.args = ("Sph"),
  anis = c(0, 1),
  alpha = 0,
  block = 0,
  beta,
  ...
)
}
\arguments{
\item{trainx}{a dataframe contains longitude (long), latitude (lat) and
predictive variables of point samples. The location information must be named
as 'long' and 'lat'.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{trainx2}{a dataframe contains longitude (long), latitude (lat) and
predictive variables of point locations (i.e., the centres of grids) to
be predicted. The location information must be named as 'long' and 'lat' and
in the first two columns respectively..}

\item{nmax}{for local kriging: the number of nearest observations that
should be used for a kriging prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{transformation}{transform the response variable to normalise the data;
can be "sqrt" for square root, "arcsine" for arcsine, "log" or "none"
for non transformation. By default, "none" is used.}

\item{delta}{numeric; to avoid log(0) in the log transformation.}

\item{formula}{formula defining the response vector and (possible) regressor.
an object (i.e., 'variogram.formula') for 'variogram' or a formula for
'krige'. see 'variogram' and 'krige' in gstat for details.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{anis}{anisotropy parameters: see notes vgm in gstat for details.}

\item{alpha}{direction in plane (x,y). see variogram in gstat for details.}

\item{block}{block size. see krige in gstat for details.}

\item{beta}{for simple kriging. see krige in gstat for details.}

\item{...}{other arguments passed on to gstat.}
}
\value{
A dataframe of longitude, latitude, predictions and variances.
}
\description{
This function is to make spatial predictions using kriging methods ('krige').
}
\note{
The variances in the output are not transformed back when a transformation
is used. This is because kriging variances are not measuring the uncertainty of
predictions but they are indicator of the spatial distribution of sample density.
The variances are exported only for interested users; and if needed,
they can be transformed back from the output.
}
\examples{
\donttest{
library(sp)
library(spm)
data(swmud)
data(sw)
okpred1 <- krigepred(swmud[, c(1,2)], swmud[, 3], sw, nmax = 7, transformation =
"arcsine", vgm.args = ("Sph"))
names(okpred1)
}

}
\references{
Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat
package. Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
