% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalfr.R
\name{mean_sb_by_split}
\alias{mean_sb_by_split}
\title{Spearman-Brown reliability coefficient averaged over each split. Can be applied to output of sh_apply}
\usage{
mean_sb_by_split(ds)
}
\arguments{
\item{ds}{(data frame) a data frame with columns "split", "score_1", and "score_2"}
}
\value{
(numeric) mean Spearman-Brown coefficient
}
\description{
Spearman-Brown reliability coefficient averaged over each split. Can be applied to output of sh_apply
}
\examples{
# N.B. This example uses R script from the vignette: "rapi_sum"
data("ds_rapi", package = "splithalfr")
rapi_fn_sets <- function (ds) {
  return (list(
    items = unlist(ds[paste("V", 1 : 23, sep = "")])
  ))
}
rapi_fn_score <- function (sets) {
  return (sum(sets$items))
}
ds_splits = sh_apply(ds_rapi, "twnr", rapi_fn_sets, rapi_fn_score, 10)
mean_sb_by_split(ds_splits)
}
