% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.iSpline}
\alias{predict.ibs}
\alias{predict.mSpline}
\title{Evaluate a Spline Basis}
\usage{
\method{predict}{ibs}(object, newx, ...)

\method{predict}{mSpline}(object, newx, ...)

\method{predict}{iSpline}(object, newx, ...)
}
\arguments{
\item{object}{Objects of class \code{\link{ibs}}, \code{\link{mSpline}}, or
\code{\link{iSpline}} having attributes describing \code{knots},
\code{degree}, etc.}

\item{newx}{The \code{x} values at which evaluations are required.}

\item{...}{Optional argument for future usage.}
}
\value{
An object just like the \code{object} input, except evaluated at
the new values of \code{x}.
}
\description{
Evaluate a predefined spline basis at given values.
}
\details{
These are methods for the generic function \code{predict} for objects
inheriting from class \code{\link{ibs}}, \code{\link{mSpline}}, or
\code{\link{iSpline}}. If \code{newx} is not given, the function returns
the input object.
}
\examples{
x <- seq(0, 1, 0.2)
knots <- c(0.3, 0.5, 0.6)
newX <- seq(0.1, 0.9, 0.2)

## for integral of B-spline
ibsMat <- ibs(x, knots = knots, degree = 2)
predict(ibsMat, newX)

## for M-spline
msMat <- mSpline(x, knots = knots, degree = 2)
predict(msMat, newX)

## for I-spline
imsMat <- iSpline(x, knots = knots, degree = 2)
predict(imsMat, newX)

}
\seealso{
\code{\link{ibs}} for integral of B-spline basis;
\code{\link{mSpline}} for M-spline basis;
\code{\link{iSpline}} for I-spline basis.
}

