% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_heartrate.R
\name{add_hr}
\alias{add_hr}
\title{Import and apply heart rate data to cardiopulmonary exercise testing data}
\usage{
add_hr(data, hr_file, hr_offset = 0)
}
\arguments{
\item{data}{A \code{data.frame} of the class \code{spiro} containing the gas
exchange data. Usually the output of a \code{\link{spiro}} call.}

\item{hr_file}{The absolute or relative path of a \code{*tcx} file that
contains additional heart rate data.}

\item{hr_offset}{An integer, corresponding to the temporal offset of the
heart-rate file. By default the start of the heart rate measurement is
linked to the start of the gas exchange measurement.}
}
\value{
A \code{data.frame} containing the spiroergometric and heart rate
data.
}
\description{
\code{add_hr()} imports an additional file containing heart rate data and
adds it to an existing spiroergometric data file.
}
\details{
Heart rate data will be imported from a \code{.tcx} file. After interpolating
the data to full seconds, it is then matched to the imported data.
}
\examples{
# Get example data
oxy_file <- spiro_example("zan_ramp")
hr_file <- spiro_example("hr_ramp.tcx")

# Import and process spiro data
oxy_data <- spiro(oxy_file)

# Add heart rate data
out <- add_hr(oxy_data, hr_file)
head(out)
}
