% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_manual_tour.r
\name{interpolate_manual_tour}
\alias{interpolate_manual_tour}
\title{Interpolates a manual tour}
\usage{
interpolate_manual_tour(basis_array, angle = 0.05)
}
\arguments{
\item{basis_array}{array, of the target bases, the extrema of the walk/segments.}

\item{angle}{The step size between interpolated frames, in radians.}
}
\description{
Internal function. Interpolates a manual tour over the stored theta, and phi
specifications. Returns an interpolated basis_array to be consumed by
\code{array2df}.
}
\examples{
## This function is not meant for external use
dat_std <- scale_sd(wine[, 2:6])
clas <- wine$Type
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)
mt <- manual_tour(bas, mv)

interp <- spinifex:::interpolate_manual_tour(basis_array = mt, angle = .1)
dim(interp)
str(interp)
}
\seealso{
Other Internal utility: 
\code{\link{.bind_elements2df}()},
\code{\link{.init4proto}},
\code{\link{.lapply_rep_len}()}
}
\concept{Internal utility}
