% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{render_}
\alias{render_}
\title{Prepate the ggplot object before passing to either animation package.}
\usage{
render_(slides, axes = "center", manip_col = "blue", ...)
}
\arguments{
\item{slides}{The result of \code{array2df()}, a long df of the projected frames.}

\item{axes}{Position of the axes: "center", "bottomleft", "off", "left",
"right". Defaults to "center".}

\item{manip_col}{String of the color to highlight the \code{manip_var} with.
Defaults to "blue".}

\item{...}{Optionally passes arguments to the projection points inside the
aesthetics; \code{geom_point(aes(...))}.}
}
\description{
Typically called by \code{render_plotly()} or \code{render_gganimate()}. Takes the
result of \code{array2df()}, and renders them into a ggplot2 object.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])
rb <- tourr::basis_random(n = ncol(flea_std))
mtour <- manual_tour(basis = rb, manip_var = 4)
sshow <- array2df(array = mtour, data = flea_std)

render_(slides = sshow)

render_(slides = sshow, axes = "bottomleft", 
        col = tourr::flea$species, pch = tourr::flea$species, cex = 2, alpha = .5)
        
render_(slides = sshow, axes = "bottomleft", 
        col = tourr::flea$species, pch = tourr::flea$species, cex = 2, alpha = .5)
}
