% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavecovar.R
\name{wavecovar}
\alias{wavecovar}
\title{Wavelet covariance analysis}
\usage{
wavecovar(f1, f2, coord, wavelet = "haar", wtrafo = "dwt")
}
\arguments{
\item{f1}{A vector of length \emph{n}.}

\item{f2}{A vector of length \emph{n}.}

\item{coord}{A matrix of two columns with corresponding cartesian
coordinates. Currently only supports integer coordinates.}

\item{wavelet}{Name of wavelet family. \code{haar}, \code{d4}, and \code{la8}.
are possible. \code{haar} is the default.}

\item{wtrafo}{Type of wavelet transform. Either \code{dwt} or \code{modwt}.
\code{dwt} is the default.}
}
\value{
Wavelet covariance for \code{f1} and \code{f2}.
}
\description{
Calculates the wavelet covariance based on a wavelet
multiresolution analysis.
}
\examples{
data(carlinadata)

coords <- carlinadata[ ,4:5]
pc <- covar.plot(carlina.horrida ~ aridity + land.use,
                 data = carlinadata,
                 coord = coords,
                 wavelet = 'd4',
                 wtrafo = 'modwt',
                 plot = 'covar')

pc$plot

}
\seealso{
\pkg{waveslim}, \code{\link{WRM}}, \code{\link{covar.plot}},
\code{\link{scaleWMRR}}
}
\author{
Gudrun Carl
}
