% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spew.R
\name{call_spew}
\alias{call_spew}
\title{Wrapper for reading, formatting, and writing SPEW ecosystems}
\usage{
call_spew(input_dir, output_dir, folders = NULL, data_group = "US",
  run_type = "SEQ", sampling_method = "uniform",
  locations_method = "uniform", output_type = "write",
  convert_count = FALSE, vars = list(household = NA, person = NA),
  road_noise = 2e-04, outfile_loc = "", timer = TRUE, verbose = TRUE)
}
\arguments{
\item{input_dir}{character specifying input directory}

\item{output_dir}{charcater specifying output directory}

\item{folders}{list specifying sub-directories for each data-source}

\item{data_group}{character, either "US", "ipums", or "none"}

\item{run_type}{Whether to run sequentially in parallel. Default is "SEQ", for 
a sequential run. If parallel, back-end is either "MPI", "SOCK", or "MC"}

\item{sampling_method}{character indicating the type of sampling 
method to use, defaults to "uniform". Can also be "ipf" with appropriate marginal data.}

\item{locations_method}{character indicating the type of location 
sampling to use, defaults to "uniform", can also be "roads".}

\item{output_type}{Default is "console" if we want to resulting population 
as an R variable. Alternative is "write", which is used on Olympus for writing 
out .csv files of the population}

\item{convert_count}{logical meant to indicate if we are going to convert 
population totals from people to household counts. Default: FALSE, assumes
the population is the total number of households}

\item{vars}{list with two elements: household and person. This specifies 
which variables to include in the corresponding household and person PUMS data-set}

\item{road_noise}{Noise added to households during road-based sampling}

\item{outfile_loc}{Defaults to "", so we print out the parallel run information. 
Only set to "/dev/null" for internal testing putposes.}

\item{timer}{logical indicating we want to time the run}

\item{verbose}{logical indicating we want to print output during the run.  Default is FALSE.#'}
}
\value{
logical indicating whether or not this run of spew ended successfully
}
\description{
Generates SPEW synthetic ecosystems on the Olympus Computing Cluster
}
