/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicDockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class SmoothDefaultTitle
extends BasicDockTitle {
    private final int ACTIVE_STATE = 0;
    private final int INACTIVE_STATE = 1;
    private int current = 0;
    private SmoothChanger changer = new SmoothChanger(2){

        protected int destination() {
            if (SmoothDefaultTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        protected void repaint(int[] current) {
            SmoothDefaultTitle.this.current = current[0];
            SmoothDefaultTitle.this.updateForegroundColor();
            SmoothDefaultTitle.this.repaint();
        }
    };

    public SmoothDefaultTitle(Dockable dockable, DockTitleVersion origin) {
        super(dockable, origin);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int duration) {
        this.changer.setDuration(duration);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    protected void updateColors() {
        super.updateColors();
        this.updateForegroundColor();
    }

    protected void updateForegroundColor() {
        boolean done = false;
        if (this.changer != null) {
            int duration = this.getDuration();
            if (this.isActive() && this.current != duration || !this.isActive() && this.current != 0) {
                double ratio = (double)this.current / (double)duration;
                this.setForeground(Colors.between(this.getInactiveTextColor(), this.getActiveTextColor(), ratio));
                done = true;
            }
            if (!done) {
                if (this.isActive()) {
                    this.setForeground(this.getActiveTextColor());
                } else {
                    this.setForeground(this.getInactiveTextColor());
                }
            }
        }
    }

    protected void paintBackground(Graphics g, JComponent component) {
        int duration = this.getDuration();
        if (this.isActive() && this.current != duration || !this.isActive() && this.current != 0) {
            double ratio = (double)this.current / (double)duration;
            Color left = Colors.between(this.getInactiveLeftColor(), this.getActiveLeftColor(), ratio);
            Color right = Colors.between(this.getInactiveRightColor(), this.getActiveRightColor(), ratio);
            GradientPaint gradient = this.getGradient(left, right, component);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gradient);
            g2.fillRect(0, 0, component.getWidth(), component.getHeight());
        } else {
            super.paintBackground(g, component);
        }
    }
}

