/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.displayer;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.displayer.TitleBarObserver;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.util.ReverseCompoundBorder;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerBackgroundComponent;
import bibliothek.gui.dock.displayer.DisplayerDockBorder;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.themes.border.BorderModifier;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;

public class NoTitleDisplayer
extends BackgroundPanel
implements DockableDisplayer,
InvisibleTabPane,
BorderedComponent {
    private Dockable dockable;
    private DockController controller;
    private DockStation station;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private PropertyValue<TabPainter> painter;
    private boolean defaultBorderHint;
    private Boolean borderHint;
    private DockableDisplayerHints hints;
    private boolean bordered;
    private boolean respectHints;
    private TitleBarObserver observer;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private InvisibleTab invisibleTab;
    private Border innerBorder;
    private Border outerBorder;
    private DisplayerBorder innerBorderModifier = new DisplayerBorder("in");
    private DisplayerBorder outerBorderModifier = new DisplayerBorder("out");
    private Background background = new Background();

    public NoTitleDisplayer(DockStation station, Dockable dockable, EclipseThemeConnector.TitleBar bar) {
        super(false, true);
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.setOpaque(false);
        this.setBackground(this.background);
        this.bordered = bar == EclipseThemeConnector.TitleBar.NONE_BORDERED || bar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.respectHints = bar == EclipseThemeConnector.TitleBar.NONE_HINTED || bar == EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        this.observer = new TitleBarObserver(station, dockable, bar){

            protected void invalidated() {
                for (DockableDisplayerListener listener : NoTitleDisplayer.this.listeners()) {
                    listener.discard(NoTitleDisplayer.this);
                }
            }
        };
        if (this.respectHints) {
            this.hints = new DockableDisplayerHints(){

                public void setShowBorderHint(Boolean border) {
                    NoTitleDisplayer.this.borderHint = border;
                    NoTitleDisplayer.this.updateFullBorder();
                }
            };
        }
        this.setStation(station);
        this.setDockable(dockable);
        this.setBorder(null);
        this.defaultBorderHint = this.bordered;
        this.painter = new PropertyValue<TabPainter>(EclipseTheme.TAB_PAINTER){

            @Override
            protected void valueChanged(TabPainter oldValue, TabPainter newValue) {
                NoTitleDisplayer.this.updateFullBorder();
                NoTitleDisplayer.this.updateInvisibleTab();
            }
        };
        this.updateFullBorder();
        this.updateInvisibleTab();
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    protected boolean getBorderHint() {
        if (this.borderHint != null) {
            return this.borderHint;
        }
        return this.defaultBorderHint;
    }

    public void updateFullBorder() {
        if ((this.bordered || this.respectHints) && this.painter != null) {
            TabPainter painter = this.painter.getValue();
            this.outerBorder = this.controller == null || painter == null || this.dockable == null ? null : (this.hints == null || this.getBorderHint() ? painter.getFullBorder(this, this.controller, this.dockable) : null);
            this.updateBorder();
        }
    }

    public void setBorder(Dockable dockable, Border border) {
        if (dockable != this.dockable) {
            throw new IllegalArgumentException("unknown dockable: " + dockable);
        }
        if ((this.bordered || this.respectHints) && (this.hints == null || this.getBorderHint())) {
            this.innerBorder = border;
            this.updateBorder();
        }
    }

    private void updateBorder() {
        Border innerBorder = this.innerBorderModifier.modify(this.innerBorder);
        Border outerBorder = this.outerBorderModifier.modify(this.outerBorder);
        if (innerBorder == null && outerBorder == null) {
            this.setBorder(null);
        } else if (innerBorder == null) {
            this.setBorder(outerBorder);
        } else if (outerBorder == null) {
            this.setBorder(innerBorder);
        } else {
            this.setBorder(new ReverseCompoundBorder(outerBorder, innerBorder));
        }
    }

    protected void updateInvisibleTab() {
        TabPainter painter;
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        if (this.dockable != null && this.painter != null && (painter = this.painter.getValue()) != null) {
            this.invisibleTab = painter.createInvisibleTab(this, this.dockable);
            this.invisibleTab.setController(this.getController());
        }
    }

    public TabPlacement getTabPlacement() {
        if (this.controller == null) {
            return null;
        }
        return this.controller.getProperties().get(StackDockStation.TAB_PLACEMENT);
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            return new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintBorder(g);
    }

    public Component getComponent() {
        return this;
    }

    public DockController getController() {
        return this.controller;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void addDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener listener) {
        this.listeners.remove(listener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    public Dockable getSelectedDockable() {
        return this.dockable;
    }

    public void setController(DockController controller) {
        DockController oldController = this.controller;
        this.controller = controller;
        if (this.painter != null) {
            this.painter.setProperties(controller == null ? null : controller.getProperties());
        }
        if (this.observer != null) {
            this.observer.setController(controller);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(controller);
        }
        this.background.setController(controller);
        this.innerBorderModifier.setController(oldController, controller);
        this.outerBorderModifier.setController(oldController, controller);
        this.updateFullBorder();
    }

    public void setDockable(Dockable dockable) {
        if (this.dockable != null) {
            this.dockable.configureDisplayerHints(null);
        }
        if (this.invisibleTab != null) {
            this.invisibleTab.setController(null);
            this.invisibleTab = null;
        }
        this.dockable = dockable;
        if (this.observer != null) {
            this.observer.setDockable(dockable);
        }
        this.removeAll();
        if (dockable != null) {
            this.add(dockable.getComponent());
            dockable.configureDisplayerHints(this.hints);
        }
        this.updateFullBorder();
        this.updateInvisibleTab();
    }

    public void setStation(DockStation station) {
        this.station = station;
    }

    public void setTitle(DockTitle title) {
        this.title = title;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
    }

    public boolean titleContains(int x, int y) {
        return false;
    }

    private class DisplayerBorder
    implements DisplayerDockBorder {
        private String suffix;
        private BorderModifier modifier;

        public DisplayerBorder(String suffix) {
            this.suffix = suffix;
        }

        public DockableDisplayer getDisplayer() {
            return NoTitleDisplayer.this;
        }

        public void setController(DockController oldController, DockController newController) {
            if (oldController != null) {
                oldController.getThemeManager().remove(this);
            }
            if (newController != null) {
                String id = "dock.border.displayer.eclipse.no_title." + this.suffix;
                newController.getThemeManager().add(id, DisplayerDockBorder.KIND, ThemeManager.BORDER_MODIFIER_TYPE, this);
            } else {
                this.set(null);
            }
        }

        public void set(BorderModifier value) {
            if (value != this.modifier) {
                this.modifier = value;
                NoTitleDisplayer.this.updateBorder();
            }
        }

        public Border modify(Border border) {
            if (this.modifier == null) {
                return null;
            }
            return this.modifier.modify(border);
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements DisplayerBackgroundComponent {
        public Background() {
            super(DisplayerBackgroundComponent.KIND, "dock.background.displayer");
        }

        public Component getComponent() {
            return this.getDisplayer().getComponent();
        }

        public DockableDisplayer getDisplayer() {
            return NoTitleDisplayer.this;
        }
    }
}

