/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.facile.station.split.LockedResizeLayoutManager;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;
import bibliothek.gui.dock.station.split.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizeNode<T>
extends ResizeElement<T> {
    private Node node;
    private double dividerSize;
    private ResizeElement<T>[] children = new ResizeElement[2];

    public ResizeNode(LockedResizeLayoutManager<T> layout, ResizeElement<T> parent, Node node) {
        super(parent, layout);
        this.node = node;
        this.children[0] = layout.toElement(this, node.getLeft());
        this.children[1] = layout.toElement(this, node.getRight());
    }

    public Node getNode() {
        return this.node;
    }

    public ResizeElement<T> getLeft() {
        return this.children[0];
    }

    public ResizeElement<T> getRight() {
        return this.children[1];
    }

    @Override
    protected ResizeElement<T>[] getChildren() {
        return this.children;
    }

    @Override
    public void prepareResize() {
        super.prepareResize();
        this.dividerSize = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL ? this.getDividerWidth() : this.getDividerHeight();
    }

    public double getDividerWidth() {
        return (double)this.node.getStation().getDividerSize() / this.node.getRoot().getWidthFactor();
    }

    public double getDividerHeight() {
        return (double)this.node.getStation().getDividerSize() / this.node.getRoot().getHeightFactor();
    }

    public double getNewDividerSize() {
        if (this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
            return this.getDividerWidth();
        }
        return this.getDividerHeight();
    }

    public double getOldDividerSize() {
        return this.dividerSize;
    }

    @Override
    protected ResizeRequest createRequest() {
        boolean horizontal;
        ResizeRequest alpha = this.getLeft().getRequest();
        ResizeRequest beta = this.getRight().getRequest();
        boolean bl = horizontal = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        if (horizontal) {
            return this.getLayout().getConflictResolver().requestHorizontal(alpha, beta, this);
        }
        return this.getLayout().getConflictResolver().requestVertical(alpha, beta, this);
    }

    @Override
    public void adapt(double deltaWidth, double deltaHeight) {
        boolean horizontal;
        ResizeRequest alpha = this.getLeft().getRequest();
        ResizeRequest beta = this.getRight().getRequest();
        boolean bl = horizontal = this.node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        if (horizontal) {
            if (alpha != null && alpha.getFractionWidth() == -1) {
                alpha = null;
            }
            if (beta != null && beta.getFractionWidth() == -1) {
                beta = null;
            }
        } else {
            if (alpha != null && alpha.getFractionHeight() == -1) {
                alpha = null;
            }
            if (beta != null && beta.getFractionHeight() == -1) {
                beta = null;
            }
        }
        if (alpha == null && beta == null) {
            if (horizontal) {
                this.getLeft().adapt(deltaWidth * this.node.getDivider(), deltaHeight);
                this.getRight().adapt(deltaWidth * (1.0 - this.node.getDivider()), deltaHeight);
            } else {
                this.getLeft().adapt(deltaWidth, deltaHeight * this.node.getDivider());
                this.getRight().adapt(deltaHeight, deltaHeight * (1.0 - this.node.getDivider()));
            }
        } else if (horizontal) {
            double delta;
            double request;
            double divider = this.node.getDivider();
            double width = this.node.getWidth();
            double dividerWidth = this.getDividerWidth();
            double leftBefore = width * divider - dividerWidth / 2.0;
            double rightBefore = width * (1.0 - divider) - dividerWidth / 2.0;
            width += deltaWidth;
            if (beta == null) {
                request = alpha.getDeltaWidth() / (double)alpha.getFractionWidth();
                delta = width <= 0.0 ? 0.0 : (request -= deltaWidth * divider) / width;
            } else if (alpha == null) {
                request = beta.getDeltaWidth() / (double)beta.getFractionWidth();
                delta = width <= 0.0 ? 0.0 : -(request -= deltaWidth * (1.0 - divider)) / width;
            } else {
                double requestLeft = alpha.getDeltaWidth() / (double)alpha.getFractionWidth();
                double requestRight = beta.getDeltaWidth() / (double)beta.getFractionWidth();
                double deltaLeft = width <= 0.0 ? 0.0 : (requestLeft -= deltaWidth * divider) / width;
                double deltaRight = width <= 0.0 ? 0.0 : -(requestRight -= deltaWidth * (1.0 - divider)) / width;
                delta = this.getLayout().getConflictResolver().resolveHorizontal(this, alpha, deltaLeft, beta, deltaRight);
            }
            divider += delta;
            divider = Math.min(1.0, Math.max(0.0, divider));
            this.node.setDivider(divider);
            double leftAfter = width * divider - dividerWidth / 2.0;
            double rightAfter = width * (1.0 - divider) - dividerWidth / 2.0;
            this.getLeft().adapt(leftAfter - leftBefore, deltaHeight);
            this.getRight().adapt(rightAfter - rightBefore, deltaHeight);
        } else {
            double delta;
            double request;
            double divider = this.node.getDivider();
            double height = this.node.getHeight();
            double dividerHeight = this.getDividerHeight();
            double topBefore = height * divider - dividerHeight / 2.0;
            double bottomBefore = height * (1.0 - divider) - dividerHeight / 2.0;
            height += deltaHeight;
            if (beta == null) {
                request = alpha.getDeltaHeight() / (double)alpha.getFractionHeight();
                delta = height <= 0.0 ? 0.0 : (request -= deltaHeight * divider) / height;
            } else if (alpha == null) {
                request = beta.getDeltaHeight() / (double)beta.getFractionHeight();
                delta = height <= 0.0 ? 0.0 : -(request -= deltaHeight * (1.0 - divider)) / height;
            } else {
                double requestTop = alpha.getDeltaHeight() / (double)alpha.getFractionHeight();
                double requestBottom = beta.getDeltaHeight() / (double)beta.getFractionHeight();
                double deltaTop = height <= 0.0 ? 0.0 : (requestTop -= deltaHeight * divider) / height;
                double deltaBottom = height <= 0.0 ? 0.0 : -(requestBottom -= deltaHeight * (1.0 - divider)) / height;
                delta = this.getLayout().getConflictResolver().resolveVertical(this, alpha, deltaTop, beta, deltaBottom);
            }
            divider += delta;
            divider = Math.min(1.0, Math.max(0.0, divider));
            this.node.setDivider(divider);
            double topAfter = height * divider - dividerHeight / 2.0;
            double bottomAfter = height * (1.0 - divider) - dividerHeight / 2.0;
            this.getLeft().adapt(deltaWidth, topAfter - topBefore);
            this.getRight().adapt(deltaWidth, bottomAfter - bottomBefore);
        }
    }
}

