/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.EclipsePanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.EclipseTabTransmitter;
import bibliothek.gui.dock.common.intern.font.FontBridgeFactory;
import bibliothek.gui.dock.common.intern.font.TabTitleFontTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.themes.font.TitleFont;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEclipseTheme
extends CDockTheme<EclipseTheme> {
    public CEclipseTheme(CControl control, EclipseTheme theme) {
        super(theme);
        this.init(control);
    }

    public CEclipseTheme(CControl control) {
        this(new EclipseTheme());
        this.init(control);
    }

    private CEclipseTheme(EclipseTheme theme) {
        super(theme, new NoStackTheme(theme));
    }

    private void init(final CControl control) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                EclipseTabTransmitter transmitter = new EclipseTabTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager manager) {
                BasicButtonTitleTransmitter transmitter = new BasicButtonTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.initDefaultFontBridges(control);
        this.putFontBridgeFactory(TitleFont.KIND_TAB_TITLE_FONT, new FontBridgeFactory(){

            public FontBridge create(FontManager manager) {
                TabTitleFontTransmitter transmitter = new TabTitleFontTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        IconManager manager = controller.getIcons();
        Map<String, Icon> icons = DockUtilities.loadIcons("data/bibliothek/gui/dock/icons/eclipse/icons.ini", "data/bibliothek/gui/dock/icons/eclipse/", CEclipseTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : icons.entrySet()) {
            manager.setIconTheme(entry.getKey(), entry.getValue());
        }
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new EclipsePanelPopupGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController controller) {
        super.uninstall(controller);
        controller.getIcons().clear(Priority.THEME);
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
    }
}

