% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R, R/setters.R
\docType{methods}
\name{ids}
\alias{ids}
\alias{ids<-}
\alias{ids,Spectra-method}
\alias{ids<-,Spectra-method}
\alias{ids<-,SpectraDataFrame-method}
\alias{ids<-,Spectra-method}
\alias{ids<-,SpectraDataFrame-method}
\title{Retrieves or sets the ids of a \code{Spectra*} object.}
\usage{
ids(object, ...)
ids(object) <- value

\S4method{ids}{Spectra}(object) <- value

\S4method{ids}{SpectraDataFrame}(object) <- value
}
\arguments{
\item{object}{an object of class \code{"Spectra"} or inheriting from this class}

\item{...}{\describe{
  \item{\code{as.vector}}{Controls whether the IDs are returned as a vector or as a data.frame (defaults to TRUE)}
}}

\item{value}{character vector for new IDs}
}
\value{
The \code{ids} methods return a vector if \code{as.vector} is TRUE,
a \code{data.frame} otherwise. The \code{"ids<-"} method return a
\code{SpectraDataFrame} object (or a \code{Spectra} object if the column in
the data slot that has been used to initiate the IDs was the only
attribute).
}
\description{
Either retrieves the wavelengths from a \code{Spectra*} object, or creates a
\code{Spectra*} object from a \code{"data.frame"} object by setting some of
its columns as the wavelengths. The \code{"ids<-"} method for 
\code{SpectraDataFrame} objects allows to use a formula interface to use a 
column in its \code{data} slot as the object IDs (see the last example provided 
in the Examples section).
}
\section{Methods}{
 \itemize{
 \item \code{ids(object, ..., as.vector = TRUE)} 
 \item \code{ids(object) <- value} 
}
}

\examples{

# Loading example data
data(oz)
spectra(oz) <- sr_no ~ ... ~ 350:2500

# Retrieving ids
ids(oz)

# Setting ids using a vector of values
ids(oz) <- seq_len(nrow(oz))
ids(oz)

# Setting ids using an attribute
oz$new_id <- seq_len(nrow(oz)) + 1000
ids(oz) <- ~ new_id
ids(oz)

}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}
}
