% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildFeatureMatrix.R
\name{BuildFeatureMatrix}
\alias{BuildFeatureMatrix}
\title{Build a Feature matrix from the with speaq 2.0 processed data}
\usage{
BuildFeatureMatrix(Y.data, var = "peakValue", impute = "zero",
  delete.below.threshold = FALSE, baselineThresh = 500, snrThres = 3,
  thresholds.pass = "any-to-pass")
}
\arguments{
\item{Y.data}{The dataset after (at least) peak detection and grouping with speaq 2.0. The dataset after peak filling is recomended.}

\item{var}{The variable to be used in the Featurematrix. This can be any of 'peakIndex', 'peakPPM', 'peakValue' (default), 'peakSNR', 'peakScale', or 'Sample'.}

\item{impute}{What to impute when a certain peak is missing for a certain sample and feature combo. Options are 'zero' (or 'zeros'), mean (imputetion with mean), randomForest (imputation with missForest function from package missForest) or kNN followed by a number indicating the amount of neighbours to use e.g. kNN5 or kNN10 (as per the method of Troyanskaya, 2001). Any other statement will produce NA's.}

\item{delete.below.threshold}{Whether to ignore peaks for which the 'var' variable has a value below 'baselineThresh' (default = FALSE).}

\item{baselineThresh}{The threshold for the 'var' variable peaks have to surpass to be included in the feature matrix.}

\item{snrThres}{The threshold for the signal-to-noise ratio of a peak.}

\item{thresholds.pass}{This variable lets users deside whether a peak has to pass all the thresholds (both snrThres and baselineThresh), or just one. (If the peak does not need to surpass any thresholds set 'delete.below.threshold' to FALSE).}
}
\value{
a matrix, data.matrix, with samples for rows and features for columns. The values in the matrix are thoes of the 'var' variable.
}
\description{
This function converts the grouped peak data to a matrix.
The matrix has features (peaks groups) in the columns and the value of the peak for every sample in the rows.
}
\examples{
subset <- GetWinedata.subset()
subset.spectra = as.matrix(subset$Spectra)
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm,
                              nCPU = 1) # nCPU set to 2 for the vignette build

test.grouped <- PeakGrouper(Y.peaks = test.peaks)
                           
test.Features <- BuildFeatureMatrix(test.grouped)

        
}
\references{
Olga Troyanskaya, Michael Cantor, Gavin Sherlock, Pat Brown, Trevor Hastie, Robert Tibshirani, David Botstein and Russ B. Altman, Missing value estimation methods for DNA microarrays BIOINFORMATICS Vol. 17 no. 6, 2001 Pages 520-525
}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
