% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUSUM.R
\docType{class}
\name{SPCCUSUM-class}
\alias{SPCCUSUM-class}
\title{CUSUM Charts}
\description{
Class extending SPCChart with a basic  CUSUM charts implementation.
}
\details{
The only slot this class contains is the data model. This data
model should already incorporate the negative mean for in-control
updates that is typical for CUSUM charts.

Let \eqn{U_t, t=1,2,\dots} be the updates from the data model. Then
the CUSUM chart is given by \eqn{S_0=0} and
\deqn{S_t=max(S_{t-1}+U_t,0)}
}
\examples{
X <-  rnorm(1000)
chart <- new("SPCCUSUM",model=SPCModelNormal(Delta=1))
\dontrun{
SPCproperty(data=X,nrep=10,chart=chart,
            property="calARL",params=list(target=100))
SPCproperty(data=X,nrep=10,chart=chart,
            property="calhitprob",params=list(target=0.05,nsteps=1e3))
SPCproperty(data=X,nrep=10,chart=chart,
            property="ARL",params=list(threshold=3))
}
SPCproperty(data=X,nrep=10,chart=chart,
            property="hitprob",params=list(threshold=3,nsteps=1e3))
#increase the number of repetitions nrep for real applications.

}

