\name{anova.ppm}
\alias{anova.ppm}
\title{ANOVA for Fitted Point Process Models}
\description{
Performs analysis of deviance for two or more fitted point process models.
}
\usage{
  \method{anova}{ppm}(object, \dots, test=NULL, adjust=TRUE, warn=TRUE)
}
\arguments{
  \item{object}{A fitted point process model
    (object of class \code{"ppm"}).
    }
    \item{\dots}{
      One or more fitted point process models.
    }
    \item{test}{
      Character string, partially matching one of
      \code{"Chisq"}, \code{"LRT"}, \code{"Rao"},
      \code{"F"} or \code{"Cp"}.
    }
    \item{adjust}{
      Logical value indicating whether to correct the
      pseudolikelihood ratio when some of the models are not Poisson
      processes.
    }
    \item{warn}{
      Logical value indicating whether to issue warnings
      if problems arise.
    }
}
\value{
  An object of class \code{"anova"}, or \code{NULL}.
}
\details{
  This is a method for \code{\link[stats]{anova}} for 
  fitted point process models (objects of class \code{"ppm"},
  usually generated by the model-fitting function \code{\link[spatstat]{ppm}}).

  If the fitted models are all Poisson point processes,
  then this function performs an Analysis of Deviance of
  the fitted models. The output shows the deviance differences
  (i.e. 2 times log likelihood ratio),
  the difference in degrees of freedom, and (if \code{test="Chi"})
  the two-sided p-values for the chi-squared tests. Their interpretation
  is very similar to that in \code{\link[stats]{anova.glm}}.

  If some of the fitted models are \emph{not} Poisson point processes,
  the `deviance' differences in this table are
  'pseudo-deviances' equal to 2 times the differences
  in the maximised values of the log pseudolikelihood (see
  \code{\link[spatstat]{ppm}}). It is not valid to compare these
  values to the chi-squared distribution. In this case,
  if \code{adjust=TRUE} (the default), the
  pseudo-deviances will be adjusted using the method of Pace et al
  (2011) so that the chi-squared test is valid.
  It is strongly advisable to perform this adjustment.
}
\section{Errors and warnings}{
  \describe{
    \item{models not nested:}{
      There may be an error message that the models are not \dQuote{nested}.
      For an Analysis of Deviance the models must be nested, i.e. one model
      must be a special case of the other. For example the point process
      model with formula \code{~x} is a special case of the model with
      formula \code{~x+y}, so these models are nested. However
      the two point process
      models with formulae \code{~x} and \code{~y} are not nested.
      
      If you get this error message and you believe that the models should
      be nested, the problem may be the inability of \R to recognise that
      the two formulae are nested. Try modifying the formulae to make
      their relationship more obvious.
    }
    \item{different sizes of dataset:}{
      There may be an error message from \code{anova.glmlist} that
      \dQuote{models were not all fitted to the same size of dataset}.
      This implies that the models were fitted using different
      quadrature schemes (see \code{\link[spatstat]{quadscheme}}) and/or
      with different edge corrections or different values of the
      border edge correction distance \code{rbord}.

      To ensure that models are comparable, check the following:
      \itemize{
	\item the models must all have been fitted to the same
	point pattern dataset, in the same window.
	\item all models must have been fitted by the same
	fitting method as specified by the argument \code{method} in
	\code{\link[spatstat]{ppm}}. 
	\item If some of the models depend on covariates, then
	they should all have been fitted using the same list of
	covariates, and using \code{allcovar=TRUE} to ensure that the
	same quadrature scheme is used.
	\item all models must have been fitted using the same edge
	correction as specified by the arguments \code{correction}
	and \code{rbord}. If you did not specify the value of
	\code{rbord}, then it may have
	taken a different value for different models. The default value of
	\code{rbord} is equal to zero for a Poisson model,
	and otherwise equals the reach (interaction distance) of the
	interaction term (see \code{\link[spatstat]{reach}}).
	To ensure that the models are comparable, set \code{rbord} to
	equal the maximum reach of the interactions that you
	are fitting.
      }
    }
  }
}
\seealso{
  \code{\link[spatstat]{ppm}}
}
\examples{
 mod0 <- ppm(swedishpines ~1)
 modx <- ppm(swedishpines ~x)
 anova(mod0, modx, test="Chi")

 modxy <- ppm(swedishpines ~x + y)
 anova(modxy, test="Chi")

 modP <- ppm(swedishpines ~1, rbord=9)
 modS <- ppm(swedishpines ~1, Strauss(9))
 anova(modP, modS, test="Chi")
}
\references{
  Baddeley, A., Turner, R. and Rubak, E. (2014)
  Adjusted composite likelihood ratio test for Gibbs point processes.
  Submitted for publication.

  Pace, L., Salvan, A. and Sartori, N. (2011)
  Adjusting composite likelihood ratio statistics.
  \emph{Statistica Sinica} \bold{21}, 129--148.
}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
\keyword{models}
\keyword{methods}
 
 
