% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_plrange.R
\name{raw_plrange}
\alias{raw_plrange}
\title{Power-law range indicator}
\usage{
raw_plrange(mat, xmin_bounds = NULL)
}
\arguments{
\item{mat}{A logical matrix (TRUE/FALSE values)}

\item{xmin_bounds}{A vector of two integer values, defining a range in which 
to search for the best xmin (see Details).}
}
\value{
The power-law range value of the matrix, a single number
}
\description{
Compute the power-law range of a matrix
}
\details{
Some ecosystems show typical changes in their patch-size 
distribution as they become more and more degraded. In particular, an 
increase in the truncation of the patch-size distribution (PSD) is expected 
to occur. The power-law range (PLR) measures the truncation of the PSD in 
a single value (see also \code{\link{patchdistr_sews}} for more details). 

To compute the PLR, power-laws are fitted with a variable 
minimum patch size (xmin) and the one with the lowest Kolmogorov-Smirnov
distance to the empirical distribution is retained. PLR is then computed 
using this best-fitting xmin: 

\deqn{\frac{log(x_{max}) - log(x_{min})}{log(x_{max}) - log(x_{smallest})}}{ (log(xmax) - log(xmin))/(log(xmax) - log(xsmallest))}

where \eqn{x_{max}}{x_max} is the maximum observed patch size, and 
\eqn{x_{smallest}}{x_smallest} is the minimum observed patch size.
}
\examples{
raw_plrange(serengeti[[1]])

}
\seealso{
\code{\link{indicator_plrange}}, \code{\link{patchdistr_sews}}
}
