% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_mif.R
\name{subset_mif}
\alias{subset_mif}
\title{Subset mif object on cellular level}
\usage{
subset_mif(mif, classifier, level, markers)
}
\arguments{
\item{mif}{An MIF object}

\item{classifier}{Column name for spatial dataframe to subset}

\item{level}{Determines which level of the classifier to keep.}

\item{markers}{vector of}
}
\value{
mif object where the spatial list only as the cell that are the specified level.
}
\description{
This function allows to subset the mif object into compartments.
For instance a mif object includes all cells and the desired analysis is based
on only the tumor or stroma compartment then this function will subset the
spatial list to just the cells in the desired compartment
}
\examples{
#' #Create mif object
library(dplyr)
x <- create_mif(clinical_data = example_clinical \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
sample_data = example_summary \%>\% 
mutate(deidentified_id = as.character(deidentified_id)),
spatial_list = example_spatial,
patient_id = "deidentified_id", 
sample_id = "deidentified_sample")

markers = c("CD3..Opal.570..Positive","CD8..Opal.520..Positive",
"FOXP3..Opal.620..Positive","PDL1..Opal.540..Positive",
"PD1..Opal.650..Positive","CD3..CD8.","CD3..FOXP3.")

mif_tumor = subset_mif(mif = x, classifier = 'Classifier.Label', 
level = 'Tumor', markers = markers)
}
