% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breeding.density.R
\name{breeding.density}
\alias{breeding.density}
\title{Breeding density areas (aka, core habitat areas)}
\usage{
breeding.density(x, pop, p = 0.75, bw = 6400, b = 8500, self = TRUE)
}
\arguments{
\item{x}{sp SpatialPointsDataFrame object}

\item{pop}{Population count/density column in x@data}

\item{p}{Target percent of population}

\item{bw}{Bandwidth distance for the kernel estimate (default 8500)}

\item{b}{Buffer distance (default 8500)}

\item{self}{(TRUE/FALSE) Should source observations be included in density (default TRUE)}
}
\value{
A list object with:

pop.pts     sp point object with points identified within the specified p

pop.area    sp polygon object of buffered points specified by parameter b

bandwidth   Specified distance bandwidth used in identifying neighbour counts

buffer      Specified buffer distance used in buffering points for pop.area

p           Specified population percent
}
\description{
Calculates breeding density areas base on population counts and spatial point density.
}
\note{
The breeding density areas model identifies the Nth-percent population exhibiting the highest spatial density and counts/frequency. It then buffers these points by a specified distance to produce breeding area polygons.

If you want to recreate the results in Doherty et al., (2010), then define bw = 6400m and b[if p < 0.75 b = 6400m, | p >= 0.75 b = 8500m]
}
\examples{
require(sp)
n=1500
bb <- rbind(c(-1281299,-761876.5),c(1915337,2566433.5))
  bb.mat <- cbind(c(bb[1,1], bb[1,2], bb[1,2], bb[1,1]),   
                  c(bb[2,1], bb[2,1], bb[2,2], bb[2,2]))  
    bbp <- Polygon(bb.mat)
     s <- spsample(bbp, n, type='random')
        pop <- SpatialPointsDataFrame(s, data.frame(ID=1:length(s), 
                                 counts=runif(length(s), 1,250)))

    bd75 <- breeding.density(pop, pop='counts', p=0.75, b=8500, bw=6400)
     plot(bd75$pop.area, main='75\% breeding density areas')
       plot(pop, pch=20, col='black', add=TRUE)
         plot(bd75$pop.pts, pch=20, col='red', add=TRUE)

}
\references{
Doherty, K.E., J.D. Tack, J.S. Evans, D.E. Naugle (2010) Mapping breeding densities of greater sage-grouse: A tool for range-wide conservation planning. Bureau of Land Management. Report Number L10PG00911
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
