% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/download.daymet.R
\name{download.daymet}
\alias{download.daymet}
\title{Download DAYMET}
\usage{
download.daymet(years, tile, data.type = "all", download.folder = getwd(),
  http = "http://daymet.ornl.gov/thredds/fileServer/ornldaac/1219/tiles")
}
\arguments{
\item{years}{Years to download (valid years 1980-2012)}

\item{tile}{Tile index value (see url for tile index grid in notes section)}

\item{data.type}{Typ of climate metric: 'all', 'vp', 'tmin', 'tmax', 'swe', 'srad', 'prcp', 'dayl'.}

\item{download.folder}{local download directory, defaults to current working directory}

\item{http}{option to change URL}
}
\value{
DAYMET netCDF format climate metrics
}
\description{
Batch download of daily gridded DAYMET climate data
}
\note{
Avaliable products

vp        Water Vapor Pressure Daily average partial pressure of water vapor

tmin      Daily minimum (degrees C) 2-meter air temperature

tmax      Daily maximum (degrees C) 2-meter air temperature

swe       Snow water equivalent (kg/m^2). Amount of water contained within snowpack.

srad      Incident shortwave radiation flux density (W/m^2), taken as average over daylight period of the day.

prcp      Daily total precipitation(mm/day), sum of all forms converted to water-equivalent.

dayl      Duration of the daylight period for the day (s/day). Calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.

DAYMET main website: \url{http://daymet.ornl.gov}

Tile index information \url{http://daymet.ornl.gov/datasupport.html}

Data respotory url: http://daymet.ornl.gov/thredds/fileServer/ornldaac/1219/tiles

Path structure: /year/tile_year/file.nc
}
\examples{
\dontrun{
# Download 2009-2010 min and max temp for tiles 11737 and 11738
 laramie.plains <- c(11737, 11738)
 my.years <- c(seq(2009,2010,1))
 download.daymet(years=my.years, tile=laramie.plains, data.type=c('tmin','tmax'))
}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
\references{
Thornton P.E., S.W. Running and M.A. White (1997) Generating surfaces of daily meteorological variables over large regions of complex terrain. Journal of Hydrology 190: 214-251.

Thornton, P.E. and S.W. Running (1999) An improved algorithm for estimating incident daily solar radiation from measurements of temperature, humidity, and precipitation. Agriculture and Forest Meteorology. 93:211-228.

Thornton, P.E., H. Hasenauer and M.A. White (2000) Simultaneous estimation of daily solar radiation and humidity from observed temperature and precipitation: An application over complex terrain in Austria. Agricultural and Forest Meteorology 104:255-271.
}

