% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getValuesBlock_enhanced}
\alias{getValuesBlock_enhanced}
\title{Easier-to-use function for grabbing a block of data out of a Raster*.}
\usage{
getValuesBlock_enhanced(x, r1 = 1, r2 = nrow(x), c1 = 1, c2 = ncol(x),
  lyrs = seq(nlayers(x)), format = "array", ...)
}
\arguments{
\item{x}{Raster* Some input Raster* object.}

\item{r1}{Numeric. The start row of the chunk.}

\item{r2}{Numeric. The end row of the chunk.}

\item{c1}{Numeric. The start column of the chunk.}

\item{c2}{Numeric. The end row of the chunk.}

\item{lyrs}{Numeric. Vector of layer IDs.  Defaults to all layers (1:nlayers(x)).}

\item{format}{Character. See Details.}

\item{...}{Other parameters.}
}
\value{
An array or raster object.
}
\description{
Easier-to-use function for grabbing a block of data out of a Raster*.
}
\details{
This allows for a larger number of output formats to be generated
when extracting chunks of data from a Raster* object.  If format="array" (default),
the chunk will be returned in a 3-d array with dimensions representing column,row,and layer.
If "raster", the chunk will be returned as a Raster* object.  If "data.frame", it will
be returned as a data.frame.  If "data.frame.dims", it will return a list, where the first
component (named "values") is the same as the data.frame when using format="data.frame", and
the second component (named "dim") is the dimensions of the extracted chunk.
}
\examples{
tahoe_highrez <- brick(system.file("external/tahoe_highrez.tif", package="spatial.tools"))
mychunk <- getValuesBlock_enhanced(tahoe_highrez,r1=100,r2=110,c1=20,c2=50)
class(mychunk)
dim(mychunk)
mychunk_raster <- getValuesBlock_enhanced(tahoe_highrez,r1=100,r2=110,c1=20,c2=50,format="raster")
mychunk_raster
}
\author{
Jonathan A. Greenberg
}
\seealso{
\code{\link[raster]{getValues}}
}

