% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_sensitivity_analysis.R
\name{emulate_efast_sampled_parameters}
\alias{emulate_efast_sampled_parameters}
\title{Emulate simulations for a set of eFAST generated parameter values}
\usage{
emulate_efast_sampled_parameters(filepath, surrogateModel, parameters,
  measures, num_curves, ensemble_set = TRUE, normalise = FALSE,
  timepoint = NULL, csv_file_input = TRUE, spartan_sample_obj = NULL,
  write_csv_file_out = TRUE, normalise_result = FALSE)
}
\arguments{
\item{filepath}{Path to the folder containing the set of CSV files for eFAST
analysis}

\item{surrogateModel}{Ensemble or emulator to use to emulate the simulation
responses for those sets}

\item{parameters}{Simulation parameter names}

\item{measures}{Simulation output response names}

\item{num_curves}{Number of resample curves used in eFAST sampling}

\item{ensemble_set}{Boolean stating whether this analysis is being run using
an ensemble of machine learning methods (TRUE), or a single emulator (FALSE)}

\item{normalise}{Whether the parameters in the sampling CSV files need to be
normalised before input to the emulator (which must take values between 0
and 1)}

\item{timepoint}{Simulation timepoint being analysed, if more than one. See
the vignette for analysing more than one timepoint}

\item{csv_file_input}{Whether parameters to emulate are being supplied in a CSV
file. Default is TRUE, with spartanDB this is false}

\item{spartan_sample_obj}{Where spartanDB is used, or another application that
supplied parameter values as an R object created by spartan's sampling method,
the name of that R object}

\item{write_csv_file_out}{Whether results for each curve should be output to a
CSV file. SpartanDB instead requires an R object containing this data, which is
returned}

\item{normalise_result}{Whether the resultant predictions should be
normalised}
}
\description{
This method runs an ensemble for all parameter value sets specified in a CSV
file generated from spartan eFAST sampling techniques. The output is a set
of  CSV files that can then be analysed using the spartan analysis methods
detailed in Technique 4.
}
