oat_process_netlogo_result <-
function(FILEPATH,NETLOGO_BEHAVIOURSPACEFILE,PARAMETERS,BASELINE,PMIN,PMAX,PINC,MEASURES,RESULTFILENAME,ATESTRESULTSFILENAME,TIMESTEP)
{
	# NOTE THAT ALTHOUGH NETLOGO FILE CONTAINS EACH PARAMETER FOR THE TURTLE, THE INPUT HERE ONLY NEEDS TO BE THE
	# PARAMETERS THAT HAVE BEEN PERTURBED

	# No longer in use, as have changed method of reading in CSV files (check.names=FALSE)
	# Check the parameter and measures strings
	#PARAMETERS<-table_header_check(PARAMETERS)
	#MEASURES<-table_header_check(MEASURES)

	## FIRSTLY READ IN THE NETLOGO RESULT FILE
	NL_RESULT<-read.csv(paste(FILEPATH,"/",NETLOGO_BEHAVIOURSPACEFILE,sep=""),sep=",",skip=6, check.names=FALSE)

	# ORDER IT BY RUN FOR EFFICIENCY LATER
	NL_RESULT_ORDERED<-NL_RESULT[order(NL_RESULT[,1]),]

	# REMOVE ALL THE OTHER TIMESTEPS AS NOT REQUIRED
	# THE TIMESTEP IS IN THE COLUMN HEADED X.step.
	# SET THIS TO NULL TO PLEASE CRAN SUBMISSION NOTE, THEN SUBSET
	# KA: REMOVED THIS APRIL 2015
	#X.step.<-NULL
	#TIMESTEP_RESULTS<-subset(NL_RESULT_ORDERED,X.step.==TIMESTEP)
	TIMESTEP_RESULTS<-subset(NL_RESULT_ORDERED,NL_RESULT_ORDERED["[step]"]==TIMESTEP)

	write.csv(TIMESTEP_RESULTS,paste(FILEPATH,"/",RESULTFILENAME,sep=""),quote = FALSE,row.names=FALSE)

	print("Analysing Netlogo Robustness Analysis File, and Generating A-Test Scores")
	oat_csv_result_file_analysis(FILEPATH,RESULTFILENAME,PARAMETERS,
	BASELINE,MEASURES,ATESTRESULTSFILENAME,PMIN=PMIN,PMAX=PMAX,
	PINC=PINC,PARAMVALS=NULL)

}
